/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: RestUtils.java 1898 2005-06-24 09:57:12Z jmettraux $
 */

//
// RestUtils.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.rest;

import java.net.URLDecoder;


/**
 * Utility methods for HTTP / REST handling
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: RestUtils.java 1898 2005-06-24 09:57:12Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class RestUtils
{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(RestUtils.class.getName());


    private final static String ENCODING = "UTF-8";
        // as recommended by the W3C

    //
    // METHODS

    /**
     * Given an HTTP request first line, extracts the value of a parameter.
     * For example :<br>
     * <pre>
     * GET /documenation.pl?action=nada&amp;topic=x&amp;year=2005
     * </pre><br>
     * extractFromLine(l, "topic")<br>
     * will yield "x"
     */
    public static String extractFromLine 
        (String line, final String key)
    throws 
        java.io.IOException
    {
        //log.debug("looking for key >"+key+"<'");
        //log.debug("line is >"+line+"<");

        int i = line.indexOf(key+"=");

        if (i < 0) return null;

        line = line.substring(i+key.length()+1);

        //log.debug("line is >"+line+"<");

        int iamp = line.indexOf("&");
        int ispc = line.indexOf(" ");

        if (iamp < 0) iamp = line.length();
        if (ispc < 0) ispc = line.length();

        if (iamp < ispc) i = iamp; else i = ispc;

        line = line.substring(0, i);

        log.debug("extractFromLine() key >"+key+"<   value >"+line+"<");

        return line;
    }

    /**
     * Turns an HTTP request line into a map of string parameters.
     * For example :<br>
     * <pre>
     * GET /documentation.pl?action=nada&amp;topic=x&amp;year=2005
     * </pre><br>
     * extractParams (l, "topic")<br>
     * will yield { "action": "nada", "topic": "x", "year": "2005" }
     */
    public static java.util.Map extractParams (final String line)
    {
        log.debug("extractParams() for '"+line+"'");

        final java.util.Map params = new java.util.HashMap();

        if (line == null) return params;
            // this is somehow too kind...

        int i = line.indexOf("?");
        
        if (i < 0) return params;
        if (i == line.length()-1) return params;

        String[] ss = line.substring(i+1).split("&");

        for (int j=0; j<ss.length; j++)
        {
            final String[] kv = ss[j].split("=");

            String k = kv[0];
            String v = "";
            if (kv.length > 1) v = kv[1];

            try
            {
                k = URLDecoder.decode(k, ENCODING);
                v = URLDecoder.decode(v, ENCODING);
            }
            catch (final java.io.UnsupportedEncodingException e)
            {
                log.warn
                    ("extractParams() encoding problem "+e+
                     "   ('"+k+"': '"+v+"')");
            }

            log.debug("extractParams() found '"+k+"' -> '"+v+"'");

            params.put(k, v);
        }

        return params;
    }

    /**
     * Same thing a extractParams(), but it works with 
     * HttpServletRequest.getQueryString() returns (which don't entail the 
     * '/documentation.pl?' part).
     */
    public static java.util.Map extractParamsFromQueryString (final String line)
    {
        return extractParams("?"+line);
    }

}
