/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: RmiBridgedRestSession.java 2321 2006-02-03 20:59:14Z jmettraux $
 */

//
// RmiBridgedRestSession.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.rest;

import openwfe.org.Service;
import openwfe.org.ServiceException;
import openwfe.org.rmi.session.WorkSessionServer;
import openwfe.org.rmi.session.WorkSessionServerImpl;


/**
 * An association with an RMI worksession, this class is used to rapidly build
 * a REST interface based on an RMI interface, this is an abstract class, the
 * association is done by implementing this class.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-02-03 21:59:14 +0100 (Fri, 03 Feb 2006) $
 * <br>$Id: RmiBridgedRestSession.java 2321 2006-02-03 20:59:14Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class RmiBridgedRestSession

    extends RestSession

{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(RmiBridgedRestSession.class.getName());
    */

    //
    // CONSTANTS and DEFINITIONS

    private final static String SESSION_SERVER_SUFFIX
        = ".workSessionServer";

    //
    // FIELDS

    private String sessionServerKey = null;

    //
    // CONSTRUCTORS

    public void init
        (final RestService service, 
         final Long sessionId, 
         final String username,
         final String password)
    throws
        ServiceException
    {
        super.init(service, sessionId, username, password);

        this.sessionServerKey = ""+this.hashCode()+SESSION_SERVER_SUFFIX;
    }

    /**
     * Returns  the WorkSessionServer instance serving logins to the RMI 
     * WorkSessions.
     */
    protected WorkSessionServer getWorkSessionServer ()
        throws Exception
    {
        WorkSessionServer result = (WorkSessionServer)this.getService()
            .getContext().lookup(sessionServerKey);

        if (result != null) return result;

        //
        // instantiating the workSessionServer
    
        result = new WorkSessionServerImpl();

        ((Service)result).init
            (this.sessionServerKey,
             this.getService().getContext(),
             this.getService().getParams());

        this.getService().getContext()
            .put(this.sessionServerKey, result);

        return result;
    }

    //
    // METHODS

    //
    // STATIC METHODS

}
