/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: LocalRemoteService.java 2321 2006-02-03 20:59:14Z jmettraux $
 */

//
// LocalRemoteService.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.rmi;

import openwfe.org.MapUtils;
import openwfe.org.Service;
import openwfe.org.AbstractService;
import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;


/**
 * This helper service instantiates and wraps a class supposed to be used 
 * remotely, the remote instance is not bound in a local registry, it is 
 * bound in the application context the LocalRemoteService instance lives
 * in.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-02-03 21:59:14 +0100 (Fri, 03 Feb 2006) $
 * <br>$Id: LocalRemoteService.java 2321 2006-02-03 20:59:14Z jmettraux $ </font>
 *
 * @author jmettraux@openwfe.org
 */
public class LocalRemoteService

    extends AbstractService

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(LocalRemoteService.class.getName());

    //
    // CONSTANTS (definitions)

    public final static String REMOTE_NAME
        = "remoteName";

    public final static String REMOTE_CLASS
        = "remoteClass";

    //
    // FIELDS

    private String remoteName = null;
    private Class remoteClass = null;
    private java.rmi.Remote remote = null;

    //
    // CONSTRUCTORS

    /**
     * will get overriden by child RemoteService
     */
    public void init 
        (final String serviceName, 
         final ApplicationContext context, 
         final java.util.Map serviceParams)
    throws 
        ServiceException
    {
        super.init(serviceName, context, serviceParams);

        localInit();

        final String remoteName = "local."+this.remoteName;
        getContext().put(remoteName, this.remote);

        log.debug
            ("init() Stored remote in context under name '"+remoteName+"'");
    }

    //
    // GETs and SETs

    /**
     * Returns the name under which the remote object was bound in the
     * application context.
     */
    public String getRemoteName () { return this.remoteName; }

    /**
     * Returns the remote object that this service wraps.
     */
    public java.rmi.Remote getRemote () { return this.remote; }

    //
    // METHODS from Service

    public void stop ()
        throws ServiceException
    {
        super.stop();

        getContext().put(this.remoteName, null);
    }

    //
    // METHODS

    /**
     * this piece of code will be used in child RemoteService
     */
    protected void localInit ()
        throws ServiceException
    {
        //
        // get server name
        
        this.remoteName = MapUtils.getAsString
            (getParams(), REMOTE_NAME, getName());

        log.info("localInit() ServerName is set to '"+this.remoteName+"'");

        //
        // locate server class
        
        String remoteClassName = MapUtils.getAsString
            (getParams(), REMOTE_CLASS);

        if (remoteClassName == null)
        {
            log.warn
                ("localInit() Parameter '"+REMOTE_CLASS+
                 "' is missing. Cannot start any rmi server.");
            throw new ServiceException
                ("Parameter '"+REMOTE_CLASS+
                 "' is missing. Cannot start any rmi server.");
        }
        try
        {
            this.remoteClass = Class.forName(remoteClassName);
            this.remote = (java.rmi.Remote)this.remoteClass.newInstance();

            if ( ! (this.remote instanceof Service))
            {
                throw new ServiceException
                    ("Class '"+remoteClassName+"' must implement interface "+
                     Service.class.getName()+".");
            }

            ((Service)this.remote).init
                ("remote."+this.remoteName, 
                 getContext(), 
                 getParams());
        }
        catch (final Throwable t)
        {
            throw new ServiceException
                ("Failed to instantiate server. Cannot continue.", t);
        }

        log.info("localInit() server class is '"+remoteClassName+"'");
    }

}
