/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: WorkSessionServerImpl.java 2351 2006-02-25 10:55:57Z jmettraux $
 */

//
// WorkSessionServerImpl.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.00 16.08.2003 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.rmi.session;

import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;
import openwfe.org.auth.OwfeCallbackHandler;


/**
 * A JAAS implementation of WorkSessionServer
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: WorkSessionServerImpl.java 2351 2006-02-25 10:55:57Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class WorkSessionServerImpl

    extends ClassedWorkSessionServer

    implements WorkSessionServer
    
{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(WorkSessionServerImpl.class.getName());

    //
    // CONSTANTS & co

    public final static String P_LOGIN_CONTEXT
        = "loginContext";

    public final static String P_CALLBACK_HANDLER_CLASS
        = "callbackHandlerClass";

    //
    // FIELDS

    private String loginContextName = null;
    private Class callbackHandlerClass = null;

    //
    // CONSTRUCTORS

    public WorkSessionServerImpl ()
        throws java.rmi.RemoteException
    {
        super();
    }

    public void init 
        (final String serviceName, 
         final ApplicationContext context, 
         final java.util.Map serviceParams)
    throws 
        //java.rmi.RemoteException
        ServiceException
    {
        super.init(serviceName, context, serviceParams);

        //
        // fetch login context name
        
        this.loginContextName = MapUtils.getMandatoryString
            (serviceParams,
             P_LOGIN_CONTEXT);

        //
        // fetch callback handler class
        
        String callbackHandlerClassName = MapUtils.getAsString
            (serviceParams, 
             P_CALLBACK_HANDLER_CLASS, 
             openwfe.org.auth.StupidCallbackHandler.class.getName());

        try
        {
            this.callbackHandlerClass = 
                Class.forName(callbackHandlerClassName);
        }
        catch (final Throwable t)
        {
            //throw new java.rmi.RemoteException
            throw new ServiceException
                ("Failed to load callbackHandlerClass '"+
                 callbackHandlerClassName+"'", t);
        }

        log.info
            ("init() callbackHandlerClass set to '"+
             callbackHandlerClassName+"'");
    }

    //
    // METHODS from Service

    /**
     * Returns null for the moment.
     */
    public org.jdom.Element getStatus ()
    {
        return new org.jdom.Element(this.getName());
    }

    //
    // METHODS from WorkSessionServer

    public java.rmi.Remote login (final String username, final String password)
        throws java.rmi.RemoteException
    {
        OwfeCallbackHandler callbackHandler = null;
        try
        {
            callbackHandler = 
                (OwfeCallbackHandler)this.callbackHandlerClass.newInstance();
            callbackHandler.init(new String[] { username, password });
        }
        catch (final Exception e)
        {
            log.debug
                ("login(u, p) failed to set up callback handler", e);

            throw new java.rmi.RemoteException
                ("failed to set up callback handler", e);
        }

        return login(callbackHandler);
    }

    public java.rmi.Remote login (final java.security.Principal principal)
        throws java.rmi.RemoteException
    {
        OwfeCallbackHandler callbackHandler = null;
        try
        {
            callbackHandler = 
                (OwfeCallbackHandler)this.callbackHandlerClass.newInstance();
            callbackHandler.init(principal);
        }
        catch (final Exception e)
        {
            log.debug
                ("login(p) failed to set up callback handler", e);

            throw new java.rmi.RemoteException
                ("failed to set up callback handler", e);
        }

        return login(callbackHandler);
    }

    private java.rmi.Remote login (final OwfeCallbackHandler callbackHandler)
        throws java.rmi.RemoteException
    {
        //
        // login

        LoginContext lc = null;
        try
        {
            lc = new LoginContext(this.loginContextName, callbackHandler);
            lc.login();
        }
        catch (final LoginException e)
        {
            log.debug("login(cbh) failed", e);

            throw new java.rmi.RemoteException("login failed", e);
        }

        //
        // set up worksession

        try
        {
            return newRemoteSession(lc.getSubject());
        }
        catch (final ServiceException e)
        {
            log.debug
                ("login(cbh) failed to instiante new remote session", e);

            throw new java.rmi.RemoteException
                ("failed to instiante new remote session", e);
        }
    }

    //
    // METHODS

}
