/*
 * Copyright (c) 2005, Phil Moore
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: MSsqlDataSource.java 2011 2005-08-10 07:05:53Z jmettraux $
 */

//
// MSsqlDataSource.java
//

package openwfe.org.sql.ds;

import net.sourceforge.jtds.jdbcx.JtdsDataSource;
import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;
import javax.naming.*;
import javax.naming.directory.*;
import javax.sql.*;
import java.sql.*;



/**
 * An OpenWFE data source for MySQL
 *
 * <p><font size=2>CVS Info :
 * <!--<br>$Author: jmettraux $-->
 * <br>$Date: 2005-08-10 09:05:53 +0200 (Wed, 10 Aug 2005) $
 * <br>$Id: MSsqlDataSource.java 2011 2005-08-10 07:05:53Z jmettraux $ </font>
 *
 * @author Phil Moore
 */
public class MSsqlDataSource

    extends OwfeDataSource

{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(MysqlDataSource.class.getName());
    */

    //
    // CONSTANTS (definitions)

    private final static String CON_VALIDITY_SQL_CODE
        = "select 1";

    public final static String P_USER = "user";
    public final static String P_PASS = "password";
    public final static String P_SERVER = "servername";
    public final static String P_DATABASE = "database";

    //
    // FIELDS

    //
    // CONSTRUCTORS

    public void init 
        (final String serviceName, 
         final ApplicationContext context, 
         final java.util.Map serviceParams)
    throws 
        ServiceException
    {

        super.init(serviceName, context, serviceParams);

        /*
        final String url = MapUtils
            .getMandatoryString(getParams(), P_URL);
        */

        final String user = MapUtils.getMandatoryString(getParams(), P_USER);
        final String password = MapUtils.getMandatoryString(getParams(), P_PASS);
        final String servername = MapUtils.getMandatoryString(getParams(), P_SERVER);
        final String database = MapUtils.getMandatoryString(getParams(), P_DATABASE);
        final net.sourceforge.jtds.jdbcx.JtdsDataSource mds =
            new net.sourceforge.jtds.jdbcx.JtdsDataSource();

        mds.setServerName(servername);
        mds.setDatabaseName(database);
        mds.setUser(user);
        mds.setPassword(password);

        this.setDataSource(mds);
    }

    //
    // METHODS from OwfeDataSource

    /**
     * This method when implemented has to return a piece of SQL code
     * that will be run against any database for connection
     * validity checking.
     * (returns "select 1")
     */
    public String getConnectionValiditySqlCode ()
    {
        return CON_VALIDITY_SQL_CODE;
    }

    //
    // METHODS from Service

    //
    // METHODS

    /*
     * The new version of the driver (3.0.11) doesn't allow for concurrent
     * connections, this releaseConnection() implementation kills the
     * connection.
     *
    public void releaseConnection ()
    {
        try
        {
            stop();
        }
        catch (Exception e)
        {
        }
    }
     *
     */

}
