/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: MysqlDataSource.java 1882 2005-05-17 16:41:07Z jmettraux $
 */

//
// MysqlDataSource.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.sql.ds;

import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;

/**
 * An OpenWFE data source for MySQL
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2005-05-17 18:41:07 +0200 (Tue, 17 May 2005) $
 * <br>$Id: MysqlDataSource.java 1882 2005-05-17 16:41:07Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class MysqlDataSource

    extends OwfeDataSource

{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(MysqlDataSource.class.getName());
    */

    //
    // CONSTANTS (definitions)

    private final static String CON_VALIDITY_SQL_CODE
        = "select 1";

    //
    // FIELDS

    //
    // CONSTRUCTORS

    public void init 
        (final String serviceName, 
         final ApplicationContext context, 
         final java.util.Map serviceParams)
    throws 
        ServiceException
    {
        super.init(serviceName, context, serviceParams);

        final String url = MapUtils
            .getMandatoryString(getParams(), P_URL);

        final com.mysql.jdbc.jdbc2.optional.MysqlDataSource mds =
            new com.mysql.jdbc.jdbc2.optional.MysqlDataSource();

        mds.setURL(url);

        setDataSource(mds);
    }

    //
    // METHODS from OwfeDataSource

    /**
     * This method when implemented has to return a piece of SQL code
     * that will be run against any database for connection
     * validity checking.
     * (returns "select 1")
     */
    public String getConnectionValiditySqlCode ()
    {
        return CON_VALIDITY_SQL_CODE;
    }

    //
    // METHODS from Service

    //
    // METHODS

    /*
     * The new version of the driver (3.0.11) doesn't allow for concurrent
     * connections, this releaseConnection() implementation kills the
     * connection.
     *
    public void releaseConnection ()
    {
        try
        {
            stop();
        }
        catch (Exception e)
        {
        }
    }
     *
     */

}
