//
// PostgresDataSource.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.sql.ds;

import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;
import org.postgresql.jdbc3.Jdbc3SimpleDataSource;


/**
 * An implementation of OwfeDataSource for PostgreSQL databases.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-01-31 20:02:13 +0100 (Tue, 31 Jan 2006) $
 * <br>$Id: PostgresDataSource.java 2316 2006-01-31 19:02:13Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class PostgresDataSource

    extends OwfeDataSource

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(PostgresDataSource.class.getName());

    //
    // CONSTANTS (definitions)

    /**
     * This datasource usually requires a 'user' attribute to be defined.
     */
    public final static String P_USER = "user";

    /**
     * This datasource usually requires a 'pass' attribute to be defined.
     */
    public final static String P_PASS = "pass";


    private final static String CON_VALIDITY_SQL_CODE
        = "SELECT 1";

    //
    // FIELDS

    //
    // CONSTRUCTORS

    public void init 
        (final String serviceName, 
         final ApplicationContext context, 
         final java.util.Map serviceParams)
    throws 
        ServiceException
    {
        super.init(serviceName, context, serviceParams);

        final String url = MapUtils.getMandatoryString(getParams(), P_URL);
        final String user = MapUtils.getMandatoryString(getParams(), P_USER);
        final String pass = MapUtils.getMandatoryString(getParams(), P_PASS);

        final Jdbc3SimpleDataSource ds = new Jdbc3SimpleDataSource();
        setUpDataSource(ds, url, user, pass);
        setDataSource(ds);
    }

    //
    // METHODS

    protected void setUpDataSource 
        (final Jdbc3SimpleDataSource source, 
         String url, 
         final String user,
         final String pass)
    throws 
        ServiceException
    {
        source.setUser(user);
        source.setPassword(pass);

        if ( ! url.startsWith("jdbc:postgresql:"))
        {
            throw new ServiceException
                ("url '"+url+"' should begin with 'jdbc:postgresql:'");
        }

        url = url.substring(16);

        if ( ! url.startsWith("//"))
        {
            //
            // database directly expressed

            log.debug("setUpDataSource() DatabaseName >"+url+"<");
            source.setDatabaseName(url);
            return;
        }

        url = url.substring(2); // skip '//'

        String[] ss = url.split("/");

        String hostAndPort = ss[0];
        String databaseName = ss[1];

        log.debug("setUpDataSource() DatabaseName >"+databaseName+"<");
        source.setDatabaseName(databaseName);

        if (hostAndPort.indexOf(":") > -1)
        {
            ss = hostAndPort.split(":");

            log.debug("setUpDataSource() ServerName >"+ss[0]+"<");
            source.setServerName(ss[0]);

            int port = -1;
            try
            {
                port = Integer.parseInt(ss[1]);
            }
            catch (NumberFormatException nfe)
            {
                throw new ServiceException
                    ("invalid port number '"+ss[1]+"'", nfe);
            }

            log.debug("setUpDataSource() PortNumber >"+port+"<");
            source.setPortNumber(port);
        }
        else
        {
            log.debug("setUpDataSource() ServerName >"+hostAndPort+"<");
            source.setServerName(hostAndPort);
        }
    }

    //
    // METHODS from OwfeDataSource

    /**
     * This method when implemented has to return a piece of SQL code
     * that will be run against any database for connection
     * validity checking.
     */
    public String getConnectionValiditySqlCode ()
    {
        return CON_VALIDITY_SQL_CODE;
    }

    //
    // METHODS from Service

}
