/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ServiceStateHelper.java 2329 2006-02-08 12:57:09Z jmettraux $
 */

//
// ServiceStateHelper.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.state;

import openwfe.org.OwfeRunnable;
import openwfe.org.ServiceException;


/**
 * A basic and simple implementation of OwfeRunnable, wrapping
 * a service State. 
 * Will be used by AbstractService and AbstractWorkSessionServer.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: ServiceStateHelper.java 2329 2006-02-08 12:57:09Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class ServiceStateHelper

    implements OwfeRunnable

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(ServiceStateHelper.class.getName());

    //
    // CONSTANTS & co

    //
    // FIELDS

    private String name = null;
    private ServiceState serviceState = null;

    //
    // CONSTRUCTORS

    /**
     * The only param is the name of the service using this helper.
     */
    public ServiceStateHelper (final String name)
    {
        super();

        this.name = name;
        this.serviceState = new RunningState();
    }

    //
    // METHODS

    //
    // METHODS from OwfeRunnable

    /**
     * Returns this name, which is the name of the service 'hiring' this
     * SessionStateHelper.
     */
    public String getName ()
    {
        return this.name;
    }

    /**
     * If the service is not running, will start it.
     */
    public void play ()
        throws ServiceException
    {
        log.info("play() requested for service '"+this.name+"'");

        if ( ! this.isRunning()) this.serviceState = new RunningState();
    }

    /**
     * If the service is running, will pause it.
     */
    public void pause ()
        throws ServiceException
    {
        log.info("pause() requested for service '"+this.name+"'");

        if (this.isRunning()) this.serviceState = new PausedState();
    }

    /**
     * Stops the service
     */
    public void stop ()
        throws ServiceException
    {
        log.info("stop() requested for service '"+this.name+"'");

        this.serviceState = new StoppedState();
    }

    /**
     * Tells the runnable to update itself (maybe reread its config).
     * It's equivalent to a "kill -HUP" on a un*x OS.
     */
    public void update ()
        throws ServiceException
    {
        log.info("update() requested for service '"+this.name+"'");

        // well, no effect here.
    }

    /**
     * Returns a ServiceState instance which tells if the service is running,
     * paused or stopped and since when. Other ServiceState implementations
     * may also be returned of course.
     */
    public ServiceState getState () 
    {
        return this.serviceState;
    }

    /**
     * Protected : sets the state of the service.
     */
    public void setState (final ServiceState state)
    {
        this.serviceState = state;
    }

    /**
     * Returns true if the service is in the RunningState ServiceState.
     */
    public boolean isRunning ()
    {
        return getState() instanceof RunningState;
    }

    //
    // STATIC METHODS

}
