/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: CronService.java 2460 2006-04-05 21:33:00Z jmettraux $
 */

//
// CronService.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.time;

import openwfe.org.AbstractService;
import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;


/**
 * A service for scheduling jobs (services that implement the Schedulable
 * interface) from within the application configuration).
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: CronService.java 2460 2006-04-05 21:33:00Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class CronService

    extends AbstractService

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(CronService.class.getName());

    //
    // CONSTANTS & co

    /**
     * The cron service at init time, is looking for params whose name
     * begin with this prefix and ends with a cron string like "4-6/2 * * * *";
     * it then schedules the service whose name is the value of the param
     * (and that must implement the Schedulable interface) for execution.
     */
    public final static String CRON_PREFIX
        = "cron:";

    //
    // FIELDS

    private Scheduler scheduler = null;

    //
    // CONSTRUCTORS

    public void init 
        (final String serviceName, 
         final ApplicationContext context, 
         final java.util.Map serviceParams)
    throws 
        ServiceException
    {
        super.init(serviceName, context, serviceParams);

        //
        // start scheduler

        this.scheduler = new Scheduler(serviceName);
        this.scheduler.setDaemon(false);
        this.scheduler.start();

        //
        // parse params

        final java.util.Iterator it = serviceParams.keySet().iterator();
        while (it.hasNext())
        {
            final String paramName = (String)it.next();

            if ( ! paramName.startsWith(CRON_PREFIX)) continue;

            final String cronLine = paramName.substring(CRON_PREFIX.length());

            final Object o = serviceParams.get(paramName);

            if (o instanceof java.util.List)
            {
                final java.util.Iterator iit = ((java.util.List)o).iterator();

                while (iit.hasNext())
                    schedule(cronLine, (String)iit.next());
            }
            else
            {
                schedule(cronLine, (String)o);
            }
        }
    }

    //
    // METHODS

    /**
     * Registers a schedule (as found in the params of the cron service).
     */
    protected void schedule 
        (final String cronLine, final String schedulableServiceName)
    throws 
        ServiceException
    {
        final Object o = this.getContext().lookup(schedulableServiceName);

        if (o == null)
        {
            throw new ServiceException
                ("'"+getName()+"' did not find schedulable service '"+
                 schedulableServiceName+"'");
        }

        if ( ! (o instanceof Schedulable))
        {
            throw new ServiceException
                ("service '"+schedulableServiceName+"' is not Schedulable");
        }

        this.scheduler.schedule
            (CronLine.parse(cronLine),
             (Schedulable)o,
             null); // params ... not needed now

        log.info
            ("scheduled '"+schedulableServiceName+"' for '"+cronLine+"'");
    }

    //
    // STATIC METHODS

}
