/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.auth;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import openwfe.org.Utils;
import openwfe.org.auth.AuthException;
import openwfe.org.misc.Text;
import org.apache.log4j.Logger;

public class Grant
implements Serializable {
    static final long serialVersionUID = -5673871754297625108L;
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$auth$Grant == null ? (class$openwfe$org$auth$Grant = Grant.class$("openwfe.org.auth.Grant")) : class$openwfe$org$auth$Grant).getName());
    public static final String NAME = "name";
    public static final String LOCATION = "location";
    public static final String CODE_SOURCE = "codeSource";
    protected String name = null;
    protected String url = null;
    protected CodeSource codeSource = null;
    protected Map permissionMap = null;
    static /* synthetic */ Class class$openwfe$org$auth$Grant;

    public Grant() {
        this.permissionMap = new HashMap(7);
    }

    public Grant(String name, String url) throws MalformedURLException {
        this(name, url, new HashSet(7));
    }

    public Grant(String name, String url, Set permissions) throws MalformedURLException {
        this.name = name;
        this.url = url;
        Certificate[] certs = null;
        this.url = Text.substitute(this.url, System.getProperties());
        this.codeSource = new CodeSource(new URL(Utils.expandUrl(this.url)), certs);
        this.permissionMap = new HashMap(permissions.size());
        Iterator it = permissions.iterator();
        while (it.hasNext()) {
            this.addPermission((Permission)it.next());
        }
    }

    public void init(Map initParams) throws AuthException {
        this.name = (String)initParams.get(NAME);
        if (this.name == null) {
            throw new AuthException("Parameter 'name' is mandatory");
        }
        try {
            this.url = (String)initParams.get(CODE_SOURCE);
            if (this.url == null) {
                this.url = (String)initParams.get(LOCATION);
            }
            log.debug((Object)("init() url is >" + this.url + "<"));
            Certificate[] certs = null;
            this.codeSource = new CodeSource(new URL(Utils.expandUrl(this.url)), certs);
        }
        catch (Exception e) {
            throw new AuthException("Failed to determine 'codeSource'", e);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getLocation() {
        return this.codeSource.getLocation().toString();
    }

    public boolean codeSourceImplies(CodeSource cs) {
        return this.codeSource.implies(cs);
    }

    public PermissionCollection getPermissions() {
        Permissions result = new Permissions();
        Iterator it = this.permissionMap.values().iterator();
        while (it.hasNext()) {
            Permission p = (Permission)it.next();
            ((PermissionCollection)result).add(p);
        }
        return result;
    }

    public Collection getPermissionValues() {
        return this.permissionMap.values();
    }

    public CodeSource getCodeSource() {
        return this.codeSource;
    }

    public void addPermission(Permission p) {
        this.permissionMap.put(Grant.computeKey(p), p);
    }

    public void removePermission(String key) {
        Object p = this.permissionMap.remove(key);
    }

    public Permission getPermission(String key) {
        return (Permission)this.permissionMap.get(key);
    }

    public static String computeKey(Permission p) {
        StringBuffer sb = new StringBuffer();
        sb.append(p.getClass().getName());
        sb.append("::");
        sb.append(p.hashCode());
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

