/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.misc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class Wget {
    public static final int READ_BUFFER_SIZE = 2048;
    public static final String BANNER = "OpenWFE Wget 0.0.2d - simple java wget";
    public static final int MAX_RETRIES = 42;
    static /* synthetic */ Class class$openwfe$org$misc$Wget;

    public static void wget(String downloadDir, String sUrl) throws Exception {
        Wget.wget(downloadDir, sUrl, false);
    }

    public static void wget(String downloadDir, String sUrl, boolean verbose) throws Exception {
        URL url = new URL(sUrl);
        URLConnection con = url.openConnection();
        int contentLength = con.getContentLength();
        if (verbose) {
            System.out.println("..wget() contentLength is " + contentLength);
        }
        if (contentLength < 0) {
            contentLength = Integer.MAX_VALUE;
        }
        int i = sUrl.lastIndexOf("/");
        String fileName = sUrl.substring(i + 1);
        fileName = downloadDir + fileName;
        if (verbose) {
            System.out.println("..wget() will save to " + fileName);
        }
        InputStream is = url.openStream();
        FileOutputStream fos = new FileOutputStream(fileName);
        byte[] buffer = new byte[2048];
        int totalRead = 0;
        int retries = 0;
        while (true) {
            int read = is.read(buffer);
            totalRead += read;
            if (verbose) {
                System.out.println("..wget() read " + read + " bytes   (" + totalRead + "/" + contentLength + ") r" + retries);
            }
            if (read > 0) {
                fos.write(buffer, 0, read);
                fos.flush();
                retries = 0;
            }
            if (totalRead >= contentLength) break;
            if (read >= 2048) continue;
            if (retries >= 42) {
                if (!verbose) break;
                System.out.println("..wget() giving up.");
                break;
            }
            if (read >= 1) continue;
            Thread.yield();
            ++retries;
        }
        fos.close();
        is.close();
    }

    private static void printUsage() {
        String cmd = "java " + (class$openwfe$org$misc$Wget == null ? (class$openwfe$org$misc$Wget = Wget.class$("openwfe.org.misc.Wget")) : class$openwfe$org$misc$Wget).getName();
        System.out.println();
        System.out.println(BANNER);
        System.out.println();
        System.out.println("USAGE :");
        System.out.println();
        System.out.print(cmd);
        System.out.println(" [-d {downloadDir}] [-v] {URL}*");
        System.out.println();
        System.out.println("Wget is a java 'wget', with not much features.");
        System.out.println();
        System.out.println("  -v : verbose");
        System.out.println("  -h : prints this usage and exits");
        System.out.println();
        System.exit(-1);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            Wget.printUsage();
        }
        boolean verbose = false;
        int index = 0;
        String downloadDir = ".";
        while (args[index].startsWith("-")) {
            if (args[index].equals("-d")) {
                if (args.length - index < 2) {
                    Wget.printUsage();
                }
                downloadDir = args[index + 1];
                index += 2;
                continue;
            }
            if (args[index].equals("-v")) {
                verbose = true;
                ++index;
                continue;
            }
            if (!args[index].equals("-h")) continue;
            Wget.printUsage();
        }
        if (!downloadDir.endsWith(File.separator)) {
            downloadDir = downloadDir + File.separator;
        }
        for (int i = index; i < args.length; ++i) {
            Wget.wget(downloadDir, args[i], verbose);
            System.out.println("...got " + args[i]);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

