/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.rest;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.ExceptionUtils;
import openwfe.org.ServiceException;
import openwfe.org.net.ChannelInputStream;
import openwfe.org.net.NetUtils;
import openwfe.org.rest.HttpException;
import openwfe.org.rest.RestService;
import openwfe.org.rest.RestUtils;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public abstract class RestSession {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$rest$RestSession == null ? (class$openwfe$org$rest$RestSession = RestSession.class$("openwfe.org.rest.RestSession")) : class$openwfe$org$rest$RestSession).getName());
    public static final String ACTION_END_WORK_SESSION = "endworksession";
    private RestService service = null;
    private ApplicationContext applicationContext = null;
    private Map serviceParams = null;
    private Long sessionId = null;
    private long lastUsed = -1L;
    static /* synthetic */ Class class$openwfe$org$rest$RestSession;
    static /* synthetic */ Class class$java$nio$channels$SelectionKey;
    static /* synthetic */ Class array$Ljava$lang$String;

    public void init(RestService service, Long sessionId, String username, String password) throws ServiceException {
        this.service = service;
        this.sessionId = sessionId;
        this.touch();
        this.authentify(username, password);
    }

    public RestService getService() {
        return this.service;
    }

    protected abstract boolean authentify(String var1, String var2) throws ServiceException;

    protected boolean evalRequest(String action, SelectionKey key, String[] headers) throws Exception {
        String methodName = "do_" + action.toLowerCase();
        Method method = this.getClass().getMethod(methodName, class$java$nio$channels$SelectionKey == null ? (class$java$nio$channels$SelectionKey = RestSession.class$("java.nio.channels.SelectionKey")) : class$java$nio$channels$SelectionKey, array$Ljava$lang$String == null ? (array$Ljava$lang$String = RestSession.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
        Object result = method.invoke((Object)this, key, headers);
        if (result == null) {
            return true;
        }
        return (Boolean)result;
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    public void handle(SelectionKey key, String[] headers) {
        this.touch();
        String firstLine = headers[0];
        String action = null;
        IOException exception = null;
        try {
            log.debug((Object)("handle() firstLine is >" + firstLine + "<"));
            action = RestUtils.extractFromLine(firstLine, "action");
        }
        catch (IOException ie) {
            log.info((Object)"Failed to parse 'action' from http request", (Throwable)ie);
            exception = ie;
        }
        if (action == null) {
            Object body = exception;
            if (body == null) {
                body = "No specific action requested";
            }
            NetUtils.httpReply(key, 400, "Bad Request", this.service.getServerName(), null, "text/plain", body);
            return;
        }
        if ((action = action.toLowerCase()).equals(ACTION_END_WORK_SESSION)) {
            if (this.service != null) {
                this.service.removeSession(this.sessionId);
            }
            log.info((Object)("Session " + this.sessionId + " ended."));
            NetUtils.httpReply(key, 200, "OK", this.service.getServerName(), null, "text/xml", new Element("bye"));
            return;
        }
        try {
            try {
                if (this.evalRequest(action, key, headers)) {
                    return;
                }
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
        }
        catch (MalformedURLException mue) {
            log.info((Object)"Malformed URL Exception : ", (Throwable)mue);
            NetUtils.httpReply(key, 400, "Bad Request", this.service.getServerName(), null, "text/plain", mue);
            return;
        }
        catch (HttpException he) {
            log.info((Object)"HTTP error : ", (Throwable)he);
            NetUtils.httpReply(key, he.getErrorCode(), he.getMessage(), this.service.getServerName(), null, "text/plain", he);
            return;
        }
        catch (Throwable t) {
            log.info((Object)"Internal Server error : ", t);
            Throwable rootCause = ExceptionUtils.getRootCause(t);
            NetUtils.httpReply(key, 500, rootCause.toString() + " : " + rootCause.getMessage(), this.service.getServerName(), null, "text/plain", t);
            return;
        }
        NetUtils.httpReply(key, 400, "Bad Request", this.service.getServerName(), null, "text/plain", "Action '" + action + "' has no implementation.");
    }

    public void touch() {
        this.lastUsed = System.currentTimeMillis();
    }

    protected void reply(SelectionKey key, Element elt) {
        NetUtils.httpReply(key, 200, "OK", this.service.getServerName(), null, "text/xml", elt);
    }

    public static String printSessions(Map sessions) {
        StringBuffer sb = new StringBuffer();
        sb.append("\n[\n ");
        Iterator it = sessions.keySet().iterator();
        while (it.hasNext()) {
            Long sessionId = (Long)it.next();
            RestSession session = (RestSession)sessions.get(sessionId);
            sb.append("    ");
            sb.append(sessionId);
            sb.append(" : ");
            sb.append(new Date(session.getLastUsed()));
            if (!it.hasNext()) continue;
            sb.append(",\n");
        }
        sb.append("\n]\n");
        return sb.toString();
    }

    public static Element parseBody(SelectionKey key, String[] headers) throws Exception {
        log.debug((Object)"parseBody()");
        int bytesToRead = RestService.determineBytesToRead(headers);
        SocketChannel channel = (SocketChannel)key.channel();
        BufferedInputStream is = new BufferedInputStream(new ChannelInputStream(channel, bytesToRead, 100));
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build((InputStream)is);
        return doc.getRootElement();
    }

    public static void rethrowAsHttpException(int httpErrorCode, Exception e) throws HttpException {
        throw new HttpException(httpErrorCode, e.getMessage());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

