/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.rmi.session;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.Map;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import openwfe.org.auth.OwfeCallbackHandler;
import openwfe.org.rmi.session.ClassedWorkSessionServer;
import openwfe.org.rmi.session.WorkSessionServer;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class WorkSessionServerImpl
extends ClassedWorkSessionServer
implements WorkSessionServer {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$rmi$session$WorkSessionServerImpl == null ? (class$openwfe$org$rmi$session$WorkSessionServerImpl = WorkSessionServerImpl.class$("openwfe.org.rmi.session.WorkSessionServerImpl")) : class$openwfe$org$rmi$session$WorkSessionServerImpl).getName());
    public static final String P_LOGIN_CONTEXT = "loginContext";
    public static final String P_CALLBACK_HANDLER_CLASS = "callbackHandlerClass";
    private String loginContextName = null;
    private Class callbackHandlerClass = null;
    static /* synthetic */ Class class$openwfe$org$rmi$session$WorkSessionServerImpl;
    static /* synthetic */ Class class$openwfe$org$auth$StupidCallbackHandler;

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        super.init(serviceName, context, serviceParams);
        this.loginContextName = MapUtils.getMandatoryString(serviceParams, P_LOGIN_CONTEXT);
        String callbackHandlerClassName = MapUtils.getAsString(serviceParams, P_CALLBACK_HANDLER_CLASS, (class$openwfe$org$auth$StupidCallbackHandler == null ? (class$openwfe$org$auth$StupidCallbackHandler = WorkSessionServerImpl.class$("openwfe.org.auth.StupidCallbackHandler")) : class$openwfe$org$auth$StupidCallbackHandler).getName());
        try {
            this.callbackHandlerClass = Class.forName(callbackHandlerClassName);
        }
        catch (Throwable t) {
            throw new ServiceException("Failed to load callbackHandlerClass '" + callbackHandlerClassName + "'", t);
        }
        log.info((Object)("init() callbackHandlerClass set to '" + callbackHandlerClassName + "'"));
    }

    public Element getStatus() {
        return new Element(this.getName());
    }

    public Remote login(String username, String password) throws RemoteException {
        OwfeCallbackHandler callbackHandler = null;
        try {
            callbackHandler = (OwfeCallbackHandler)this.callbackHandlerClass.newInstance();
            callbackHandler.init(new String[]{username, password});
        }
        catch (Exception e) {
            log.debug((Object)"login(u, p) failed to set up callback handler", (Throwable)e);
            throw new RemoteException("failed to set up callback handler", e);
        }
        return this.login(callbackHandler);
    }

    public Remote login(Principal principal) throws RemoteException {
        OwfeCallbackHandler callbackHandler = null;
        try {
            callbackHandler = (OwfeCallbackHandler)this.callbackHandlerClass.newInstance();
            callbackHandler.init(principal);
        }
        catch (Exception e) {
            log.debug((Object)"login(p) failed to set up callback handler", (Throwable)e);
            throw new RemoteException("failed to set up callback handler", e);
        }
        return this.login(callbackHandler);
    }

    private Remote login(OwfeCallbackHandler callbackHandler) throws RemoteException {
        LoginContext lc = null;
        try {
            lc = new LoginContext(this.loginContextName, callbackHandler);
            lc.login();
        }
        catch (LoginException e) {
            log.debug((Object)"login(cbh) failed", (Throwable)e);
            throw new RemoteException("login failed", e);
        }
        try {
            return this.newRemoteSession(lc.getSubject());
        }
        catch (ServiceException e) {
            log.debug((Object)"login(cbh) failed to instiante new remote session", (Throwable)e);
            throw new RemoteException("failed to instiante new remote session", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

