/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.shell;

import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CmdHandler {
    public static final Boolean DO_NOT_EXIT = new Boolean(false);
    public static final Boolean DO_EXIT = new Boolean(true);
    private final Pattern p = Pattern.compile("[^ \"]+|\".*\"");
    private String[] verbs;
    private final Object commandObject;
    private String verb = null;
    private String[] args = null;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class array$Ljava$lang$String;

    public CmdHandler(Object o) {
        this.commandObject = o;
        ArrayList<String> methodList = new ArrayList<String>();
        Method[] methods = this.commandObject.getClass().getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] paramTypes;
            int modifier;
            if (!methods[i].getReturnType().equals(class$java$lang$Boolean == null ? CmdHandler.class$("java.lang.Boolean") : class$java$lang$Boolean) || ((modifier = methods[i].getModifiers()) & 1) == 0 || (modifier & 8) != 0 || (paramTypes = methods[i].getParameterTypes()).length != 1 || !paramTypes[0].equals(array$Ljava$lang$String == null ? CmdHandler.class$("[Ljava.lang.String;") : array$Ljava$lang$String) || !methods[i].getName().startsWith("do_")) continue;
            methodList.add(methods[i].getName().substring(3));
        }
        if (methodList.size() == 0) {
            throw new IllegalArgumentException("No public do_VERB(String[]) methods were found.");
        }
        methodList.add("help");
        this.verbs = new String[methodList.size()];
        this.verbs = methodList.toArray(this.verbs);
        Arrays.sort(this.verbs);
    }

    public void parse(String line) {
        this.verb = null;
        this.args = null;
        Matcher m = this.p.matcher(line.trim());
        if (m.find()) {
            String v = m.group().toLowerCase();
            for (int i = 0; i < this.verbs.length; ++i) {
                if (!this.verbs[i].startsWith(v)) continue;
                this.verb = this.verbs[i];
                break;
            }
            if (this.verb != null) {
                ArrayList<String> argsList = new ArrayList<String>();
                while (m.find()) {
                    String arg = m.group();
                    if (arg.startsWith("\"") && arg.endsWith("\"")) {
                        arg = arg.substring(1, arg.length() - 1);
                    }
                    argsList.add(arg);
                }
                this.args = new String[argsList.size()];
                this.args = argsList.toArray(this.args);
            }
        } else {
            this.args = new String[0];
        }
    }

    public String getVerb() {
        return this.verb;
    }

    public String[] getArgs() {
        return this.args;
    }

    public boolean invoke(Object o) {
        boolean exiting = false;
        if (this.getVerb().equals("help")) {
            this.help(o, this.getArgs());
            return false;
        }
        String methodName = "do_" + this.getVerb();
        try {
            Method command = o.getClass().getDeclaredMethod(methodName, array$Ljava$lang$String == null ? (array$Ljava$lang$String = CmdHandler.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            Boolean b = (Boolean)command.invoke(o, new Object[]{this.getArgs()});
            exiting = b;
        }
        catch (InvocationTargetException ite) {
            System.out.println("\n" + ite.getCause().toString() + "\n");
        }
        catch (NoSuchMethodException nsme) {
            System.out.println("Unimplemented command.");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return exiting;
    }

    private void help(Object o, String[] args) {
        if (args.length < 1) {
            System.out.println();
            System.out.println("help [<command name>]");
            System.out.println("\nAvailable commands are:");
            for (int i = 0; i < this.verbs.length; ++i) {
                System.out.print(this.verbs[i] + " ");
            }
            System.out.println();
        } else {
            String cmd = args[0].toLowerCase();
            boolean found = false;
            for (int i = 0; i < this.verbs.length; ++i) {
                if (!this.verbs[i].startsWith(cmd)) continue;
                try {
                    String methodName = "help_" + this.verbs[i];
                    Method command = o.getClass().getDeclaredMethod(methodName, new Class[0]);
                    command.invoke(o, new Object[0]);
                }
                catch (Throwable t) {
                    System.out.println("No help is available for command " + this.verbs[i] + ".");
                }
                found = true;
                break;
            }
            if (!found) {
                System.out.println("Unrecognised command.");
            }
        }
    }

    public void commandLoop(String prompt, BufferedReader reader) {
        boolean exiting = false;
        while (!exiting) {
            String line;
            try {
                do {
                    System.out.print(prompt);
                } while ((line = reader.readLine().trim()).length() == 0);
            }
            catch (IOException ioe) {
                break;
            }
            this.parse(line);
            if (this.getVerb() != null) {
                if (!this.invoke(this.commandObject)) continue;
                break;
            }
            System.out.println("Unrecognised command.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

