/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.ServiceException;
import openwfe.org.sql.ds.OwfeDataSource;
import org.apache.log4j.Logger;

public abstract class SqlUtils {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$sql$SqlUtils == null ? (class$openwfe$org$sql$SqlUtils = SqlUtils.class$("openwfe.org.sql.SqlUtils")) : class$openwfe$org$sql$SqlUtils).getName());
    static /* synthetic */ Class class$openwfe$org$sql$SqlUtils;

    public static void closeStatement(Statement st, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
            if (st != null) {
                st.close();
            }
        }
        catch (Throwable t) {
            log.debug((Object)"closeStatement() problem when disposing of sql resources", t);
        }
    }

    public static void closeStatement(Statement st) {
        SqlUtils.closeStatement(st, null);
    }

    public static void closeConnection(Connection con) {
        try {
            con.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void rollback(Connection con) {
        try {
            con.rollback();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNewInsertId(Connection con, String tableName, String idColName) throws SQLException {
        Statement st = null;
        ResultSet rs = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("SELECT MAX(");
            sb.append(idColName);
            sb.append(") FROM ");
            sb.append(tableName);
            String query = sb.toString();
            st = con.createStatement();
            rs = st.executeQuery(query);
            if (rs.next()) {
                long l = rs.getLong(1) + 1L;
                return l;
            }
            long l = 0L;
            return l;
        }
        finally {
            rs.close();
            st.close();
        }
    }

    public static String buildPreparedInsertString(String tableName, String[] colNames) {
        ArrayList<Character> values = new ArrayList<Character>(colNames.length);
        for (int i = 0; i < colNames.length; ++i) {
            values.add(new Character('?'));
        }
        return SqlUtils.buildInsertString(tableName, colNames, values);
    }

    public static String buildInsertString(String tableName, String[] colNames, List values) {
        if (colNames.length != values.size()) {
            throw new IllegalArgumentException("number of columns doesn't match number of values for table '" + tableName + "'");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ");
        sb.append(tableName);
        sb.append(" (");
        for (int i = 0; i < colNames.length; ++i) {
            sb.append(colNames[i]);
            if (i >= colNames.length - 1) continue;
            sb.append(", ");
        }
        sb.append(") VALUES (");
        Iterator it = values.iterator();
        while (it.hasNext()) {
            Object oVal = it.next();
            if (oVal == null) {
                sb.append("NULL");
            } else if (oVal instanceof String) {
                sb.append(SqlUtils.prepareString(oVal.toString()));
            } else if (oVal instanceof java.sql.Date) {
                sb.append("'").append(oVal.toString()).append("'");
            } else {
                sb.append(oVal.toString());
            }
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
        String result = sb.toString();
        return result;
    }

    public static String buildUpdateString(String tableName, String[] colNames, List values, String whereClause) {
        if (colNames.length != values.size()) {
            throw new IllegalArgumentException("number of columns doesn't match number of values for table '" + tableName + "'");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE ");
        sb.append(tableName);
        sb.append(" SET ");
        Iterator it = values.iterator();
        for (int i = 0; i < colNames.length; ++i) {
            sb.append(colNames[i]);
            sb.append(" = ");
            Object oVal = it.next();
            if (oVal == null) {
                sb.append("NULL");
            } else if (oVal instanceof String) {
                sb.append(SqlUtils.prepareString(oVal.toString()));
            } else if (oVal instanceof Date) {
                sb.append(SqlUtils.prepareString(oVal.toString()));
            } else {
                sb.append(oVal.toString());
            }
            if (i >= colNames.length - 1) continue;
            sb.append(", ");
        }
        if (whereClause != null) {
            sb.append(" WHERE ");
            sb.append(whereClause);
        } else {
            log.debug((Object)"buildUpdateString() Warning : null 'whereClause' !");
        }
        String result = sb.toString();
        log.debug((Object)("buildUpdateString() :\n>" + result + "<"));
        return result;
    }

    public static String buildDeleteString(String tableName, String whereClause) {
        StringBuffer sb = new StringBuffer();
        sb.append("DELETE FROM ");
        sb.append(tableName);
        sb.append(" WHERE ");
        sb.append(whereClause);
        return sb.toString();
    }

    public static String buildQueryString(String tableName, String[] colNames, String whereClause) {
        return SqlUtils.buildQueryString(tableName, colNames, whereClause, null);
    }

    public static String buildQueryString(String tableName, String[] colNames, String whereClause, String orderClause) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ");
        for (int i = 0; i < colNames.length; ++i) {
            sb.append(colNames[i]);
            if (i >= colNames.length - 1) continue;
            sb.append(", ");
        }
        sb.append(" FROM ").append(tableName);
        if (whereClause != null) {
            sb.append(" WHERE ").append(whereClause);
        }
        if (orderClause != null) {
            sb.append(" ORDER BY ").append(orderClause);
        }
        return sb.toString();
    }

    public static OwfeDataSource lookupDataSource(ApplicationContext context, Map serviceParams) throws ServiceException {
        return OwfeDataSource.lookupDataSource(context, serviceParams);
    }

    public static String prepareString(String in) {
        if (in == null) {
            return "NULL";
        }
        String result = in.replaceAll("'", "''");
        result = "'" + result + "'";
        return result;
    }

    public static String norm(String in) {
        if (in == null) {
            return null;
        }
        if ((in = in.trim()).length() < 1) {
            return null;
        }
        int i = in.indexOf("\"");
        int j = in.indexOf(";");
        if (j > -1 && j < i) {
            i = j;
        }
        if (i > -1) {
            in = in.substring(0, i);
        }
        in = in.replaceAll("'", "''");
        return in;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

