/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.status;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.Service;
import openwfe.org.ServiceException;
import openwfe.org.net.NetUtils;
import openwfe.org.net.SocketService;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class StatusService
extends SocketService {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$status$StatusService == null ? (class$openwfe$org$status$StatusService = StatusService.class$("openwfe.org.status.StatusService")) : class$openwfe$org$status$StatusService).getName());
    public static final String SERVER_NAME = "$Id: StatusService.java 1882 2005-05-17 16:41:07Z jmettraux $";
    public static final String STATUS = "status";
    public static final String NO_SERVICE = "no-such-service";
    public static final String PARAM = "param";
    public static final String NAME = "param-name";
    public static final String VALUE = "param-value";
    static /* synthetic */ Class class$openwfe$org$status$StatusService;

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        super.init(serviceName, context, serviceParams);
    }

    public void handle(SelectionKey key) throws ServiceException {
        try {
            SocketChannel channel = (SocketChannel)key.channel();
            log.debug((Object)("handle() incoming connection from " + channel.socket().getInetAddress()));
            BufferedReader reader = new BufferedReader(NetUtils.channelToReader(channel));
            String request = reader.readLine();
            log.debug((Object)("handle() request is \n>" + request + "<"));
            String[] ss = request.split(" ");
            if (ss.length < 3) {
                NetUtils.httpReply(key, 400, "Bad Request", SERVER_NAME, null, "text/plain", "Bad Request");
                return;
            }
            if (!ss[0].toLowerCase().equals("get")) {
                NetUtils.httpReply(key, 403, "only GET method is allowed", SERVER_NAME, null, "text/plain", "only GET method is allowed");
                return;
            }
            String target = ss[1];
            this.replyWithStatus(key, target);
        }
        catch (IOException ie) {
            throw new ServiceException("Socket handling failed", ie);
        }
    }

    protected void replyWithStatus(SelectionKey key, String target) {
        Element rootElt = new Element(STATUS);
        if (target.equals("/")) {
            this.getContext().outputStatus(rootElt);
        } else {
            Element elt;
            Object o;
            if (target.startsWith("/")) {
                target = target.substring(1);
            }
            if ((o = this.getContext().lookup(target)) == null) {
                elt = new Element(NO_SERVICE);
                elt.addContent(target);
                rootElt.addContent((Content)elt);
            } else if (!(o instanceof Service)) {
                elt = new Element(PARAM);
                Element name = new Element(NAME);
                name.addContent(target);
                elt.addContent((Content)name);
                Element value = new Element(VALUE);
                value.addContent(o.toString());
                elt.addContent((Content)value);
                rootElt.addContent((Content)elt);
            } else {
                rootElt.addContent((Content)((Service)o).getStatus());
            }
        }
        XMLOutputter out = XmlUtils.getXMLOutputter();
        String content = out.outputString(rootElt);
        NetUtils.httpReply(key, 200, "OK", SERVER_NAME, null, "text/xml", content);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

