/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.time;

import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import openwfe.org.time.CronLine;
import openwfe.org.time.Schedulable;
import openwfe.org.time.Time;
import org.apache.log4j.Logger;

public class Scheduler {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$time$Scheduler == null ? (class$openwfe$org$time$Scheduler = Scheduler.class$("openwfe.org.time.Scheduler")) : class$openwfe$org$time$Scheduler).getName());
    private String name = null;
    private long sleepTime = 250L;
    private SchedulerThread thread = null;
    private List pendingJobs = new LinkedList();
    private boolean daemonIfIdle = false;
    private HashMap cronEntries = null;
    private long lastGivenCronId = -1L;
    private long lastCronMinute = -1L;
    static /* synthetic */ Class class$openwfe$org$time$Scheduler;

    public Scheduler() {
        this("scheduler");
    }

    public Scheduler(String name) {
        this.name = name;
        this.thread = new SchedulerThread(this.name);
        this.cronEntries = new LinkedHashMap();
    }

    public String getName() {
        return this.name;
    }

    public void setDaemon(boolean b) {
        this.thread.setDaemon(b);
    }

    public boolean isDaemon() {
        return this.thread.isDaemon();
    }

    public void setDaemonIfIdle(boolean b) {
        this.daemonIfIdle = b;
    }

    public boolean isDaemonIfIdle() {
        return this.daemonIfIdle;
    }

    public void setPrecision(float f) {
        this.sleepTime = (int)(f * 1000.0f);
    }

    public void stop() {
        this.thread.setRunning(false);
        this.thread = new SchedulerThread(this.name);
    }

    public void start() {
        this.thread.start();
    }

    public synchronized boolean scheduleAt(long at, Schedulable s, Object[] params) {
        if (at <= System.currentTimeMillis() + this.sleepTime) {
            return false;
        }
        this.restartThread(false);
        JobEntry newjob = new JobEntry(at, s, params);
        if (this.pendingJobs.size() < 1) {
            this.pendingJobs.add(newjob);
            return true;
        }
        int insertionPoint = 0;
        int i = 0;
        while (i <= this.pendingJobs.size()) {
            if (i == this.pendingJobs.size()) {
                this.pendingJobs.add(newjob);
                break;
            }
            JobEntry je = (JobEntry)this.pendingJobs.get(i);
            if (at == je.getAt()) {
                this.pendingJobs.add(i, newjob);
                break;
            }
            if (at <= je.getAt()) {
                this.pendingJobs.add(insertionPoint, newjob);
                break;
            }
            insertionPoint = i++;
        }
        return true;
    }

    public boolean scheduleAt(String isoDate, Schedulable s, Object[] params) throws ParseException {
        return this.scheduleAt(Time.fromIsoDate(isoDate), s, params);
    }

    public boolean scheduleIn(long in, Schedulable s, Object[] params) {
        return this.scheduleAt(System.currentTimeMillis() + in, s, params);
    }

    public boolean scheduleIn(String in, Schedulable s, Object[] params) {
        return this.scheduleIn(Time.parseTimeString(in), s, params);
    }

    public synchronized Long schedule(CronLine cl, Schedulable s, Object[] params) {
        ++this.lastGivenCronId;
        Long cronId = new Long(this.lastGivenCronId);
        this.cronEntries.put(cronId, new CronEntry(cl, s, params));
        return cronId;
    }

    public Long schedule(String sCron, Schedulable s, Object[] params) {
        return this.schedule(CronLine.parse(sCron), s, params);
    }

    public synchronized boolean unschedule(Long cronId) {
        Object o = this.cronEntries.remove(cronId);
        return o != null;
    }

    private synchronized void restartThread(boolean daemon) {
        if (daemon == this.thread.isDaemon()) {
            return;
        }
        this.thread.setRunning(false);
        this.thread = new SchedulerThread(this.name);
        this.thread.setDaemon(daemon);
        this.thread.start();
    }

    protected synchronized void wakeup() {
        while (true) {
            long now;
            long minute;
            if ((minute = (now = System.currentTimeMillis()) / 60000L) > this.lastCronMinute) {
                this.lastCronMinute = minute;
                Iterator it = this.cronEntries.keySet().iterator();
                while (it.hasNext()) {
                    CronEntry ce = (CronEntry)this.cronEntries.get(it.next());
                    if (!ce.matches(now)) continue;
                    ce.trigger();
                }
            }
            if (this.pendingJobs.size() < 1) {
                if (!this.daemonIfIdle) break;
                this.restartThread(true);
                break;
            }
            JobEntry job = (JobEntry)this.pendingJobs.get(0);
            if (job.getAt() > now) break;
            if (job.getAt() <= now) {
                job.trigger();
            }
            this.pendingJobs.remove(0);
        }
    }

    public static void main(String[] args) throws Exception {
        Scheduler s = new Scheduler();
        s.setDaemon(false);
        s.start();
        System.out.println("* Scheduler started at " + new Date());
        long at = System.currentTimeMillis() + 5000L;
        System.out.println("    + scheduling job at " + new Date(at));
        s.scheduleAt(at, new Schedulable(){

            public void trigger(Object[] params) {
                System.out.println(". (1) triggered at " + new Date());
            }

            public Long reschedule(Scheduler s) {
                return new Long(-1L);
            }
        }, null);
        s.schedule(CronLine.parse("4-6/2 * * * *"), new Schedulable(){

            public void trigger(Object[] params) {
                System.out.println(". (c) triggered at " + new Date());
            }

            public Long reschedule(Scheduler s) {
                return new Long(-1L);
            }
        }, null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SchedulerThread
    extends Thread {
        private boolean running = false;

        public SchedulerThread(String name) {
            this.setName(name);
        }

        public void run() {
            while (true) {
                try {
                    while (this.running) {
                        Scheduler.this.wakeup();
                        SchedulerThread.sleep(Scheduler.this.sleepTime);
                    }
                }
                catch (InterruptedException ie) {
                    continue;
                }
                catch (Throwable t) {
                    log.debug((Object)"run() schedule problem", t);
                    continue;
                }
                break;
            }
        }

        public void start() {
            if (this.running) {
                return;
            }
            this.running = true;
            super.start();
        }

        public void setRunning(boolean b) {
            this.running = b;
        }
    }

    private static class JobEntry
    extends Entry {
        protected long at = -1L;

        public JobEntry(long at, Schedulable target, Object[] params) {
            super(target, params);
            this.at = at;
        }

        public long getAt() {
            return this.at;
        }
    }

    private static class CronEntry
    extends Entry {
        protected CronLine cronLine = null;

        public CronEntry(CronLine cl, Schedulable s, Object[] params) {
            super(s, params);
            this.cronLine = cl;
        }

        public boolean matches(long t) {
            return this.cronLine.matches(t);
        }
    }

    private static class Entry {
        protected Schedulable target = null;
        protected Object[] params = null;

        public Entry(Schedulable s, Object[] params) {
            this.target = s;
            this.params = params;
        }

        public void trigger() {
            this.target.trigger(this.params);
        }
    }
}

