/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class ReflectionUtils {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$ReflectionUtils == null ? (class$openwfe$org$ReflectionUtils = ReflectionUtils.class$("openwfe.org.ReflectionUtils")) : class$openwfe$org$ReflectionUtils).getName());
    public static final String P_CLASS = "class";
    private static final String IS = "is";
    private static final String GET = "get";
    private static final String SET = "set";
    private static Map fieldCache = new HashMap();
    static /* synthetic */ Class class$openwfe$org$ReflectionUtils;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$String;

    public static Object initObject(Object o, Map initParameters) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = o.getClass();
        Method initMethod = clazz.getMethod("init", class$java$util$Map == null ? (class$java$util$Map = ReflectionUtils.class$("java.util.Map")) : class$java$util$Map);
        initMethod.invoke(o, initParameters);
        return o;
    }

    public static Object initObjectOfClass(String className, Map initParameters) throws Exception {
        Class<?> clazz = Class.forName(className);
        Object instance = clazz.newInstance();
        return ReflectionUtils.initObject(instance, initParameters);
    }

    public static Object initObject(Map initParameters) throws Exception {
        String className = (String)initParameters.get(P_CLASS);
        if (className == null) {
            throw new IllegalArgumentException("There is no parameter 'class' (" + (class$openwfe$org$ReflectionUtils == null ? (class$openwfe$org$ReflectionUtils = ReflectionUtils.class$("openwfe.org.ReflectionUtils")) : class$openwfe$org$ReflectionUtils).getName() + ".P_CLASS). Cannot init instance.");
        }
        return ReflectionUtils.initObjectOfClass(className, initParameters);
    }

    public static Object getAttribute(Object o, String attributeName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = o.getClass();
        String methodName = GET + attributeName.substring(0, 1).toUpperCase() + attributeName.substring(1);
        Method getMethod = clazz.getMethod(methodName, new Class[0]);
        return getMethod.invoke(o, new Object[0]);
    }

    public static Object setAttribute(Object o, String attributeName, Object value) throws Exception {
        Class<?> clazz = o.getClass();
        String methodName = SET + attributeName.substring(0, 1).toUpperCase() + attributeName.substring(1);
        Method method = null;
        Class<?> parameterClass = null;
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!m.getName().equals(methodName) || m.getParameterTypes().length != 1) continue;
            method = m;
            parameterClass = m.getParameterTypes()[0];
            break;
        }
        if (method == null) {
            throw new NoSuchMethodException("No method named '" + methodName + "' with 1! parameter in class '" + clazz.getName() + "'");
        }
        value = ReflectionUtils.buildInstance(parameterClass, value);
        return method.invoke(o, value);
    }

    public static Class getAttributeClass(Class beanClass, String attributeName) throws Exception {
        String methodName = GET + attributeName.substring(0, 1).toUpperCase() + attributeName.substring(1);
        Method m = beanClass.getMethod(methodName, new Class[0]);
        return m.getReturnType();
    }

    public static Class getItemClass(Class arrayClass) throws ClassNotFoundException {
        String arrayClassName = arrayClass.getName();
        if (arrayClassName.length() > 2) {
            String itemClassName = arrayClassName.substring(2, arrayClassName.length() - 1);
            return Class.forName(itemClassName);
        }
        char c = arrayClassName.charAt(1);
        if (c == 'I') {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = ReflectionUtils.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        if (c == 'J') {
            return class$java$lang$Long == null ? (class$java$lang$Long = ReflectionUtils.class$("java.lang.Long")) : class$java$lang$Long;
        }
        if (c == 'F') {
            return class$java$lang$Float == null ? (class$java$lang$Float = ReflectionUtils.class$("java.lang.Float")) : class$java$lang$Float;
        }
        if (c == 'D') {
            return class$java$lang$Double == null ? (class$java$lang$Double = ReflectionUtils.class$("java.lang.Double")) : class$java$lang$Double;
        }
        if (c == 'B') {
            return class$java$lang$Byte == null ? (class$java$lang$Byte = ReflectionUtils.class$("java.lang.Byte")) : class$java$lang$Byte;
        }
        if (c == 'C') {
            return class$java$lang$Character == null ? (class$java$lang$Character = ReflectionUtils.class$("java.lang.Character")) : class$java$lang$Character;
        }
        if (c == 'S') {
            return class$java$lang$Short == null ? (class$java$lang$Short = ReflectionUtils.class$("java.lang.Short")) : class$java$lang$Short;
        }
        if (c == 'Z') {
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = ReflectionUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }
        return null;
    }

    public static boolean isPrimitiveArray(Class clazz) {
        if (!clazz.isArray()) {
            return false;
        }
        String s = clazz.getName();
        if (s.length() != 2) {
            return false;
        }
        if (s.charAt(0) != '[') {
            return false;
        }
        char c = s.charAt(1);
        return c == 'I' || c == 'J' || c == 'F' || c == 'D' || c == 'B' || c == 'C' || c == 'S' || c == 'Z';
    }

    public static List listAttributes(Object o) {
        Class<?> clazz = o.getClass();
        Method[] methods = clazz.getMethods();
        ArrayList<String> attributeNames = new ArrayList<String>(methods.length);
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!m.getName().startsWith(GET) || m.getParameterTypes().length != 0) continue;
            String attributeName = m.getName().substring(3, 4).toLowerCase() + m.getName().substring(4);
            attributeNames.add(attributeName);
        }
        return attributeNames;
    }

    public static Object buildPrimitive(Class primitiveType, Object value) {
        String s = primitiveType.getName();
        String v = value.toString().trim();
        if (s.equals("char")) {
            if (v.length() < 1) {
                return null;
            }
            return new Character(v.charAt(0));
        }
        if (s.equals("int")) {
            return new Integer(v);
        }
        if (s.equals("short")) {
            return new Short(v);
        }
        if (s.equals("byte")) {
            return new Byte(v);
        }
        if (s.equals("long")) {
            return new Long(v);
        }
        if (s.equals("float")) {
            return new Float(v);
        }
        if (s.equals("double")) {
            return new Double(v);
        }
        if (s.equals("boolean")) {
            return new Boolean(v.trim().toLowerCase().equals("true"));
        }
        return null;
    }

    public static Object buildPrimitiveArray(Class primitiveArrayType, Object value) throws ClassNotFoundException {
        char c = primitiveArrayType.getName().charAt(1);
        Object[] result = null;
        if (c == 'I') {
            result = new int[Array.getLength(value)];
        } else if (c == 'J') {
            result = new long[Array.getLength(value)];
        } else if (c == 'F') {
            result = new float[Array.getLength(value)];
        } else if (c == 'D') {
            result = new double[Array.getLength(value)];
        } else if (c == 'B') {
            result = new byte[Array.getLength(value)];
        } else if (c == 'C') {
            result = new char[Array.getLength(value)];
        } else if (c == 'S') {
            result = new short[Array.getLength(value)];
        } else if (c == 'Z') {
            result = new boolean[Array.getLength(value)];
        }
        if (result == null) {
            throw new ClassNotFoundException("Cannot build array of class " + primitiveArrayType.getName());
        }
        for (int i = 0; i < Array.getLength(value); ++i) {
            Array.set(result, i, Array.get(value, i));
        }
        return result;
    }

    public static Object buildInstance(Class targetClass, Object value) throws Exception {
        if (value == null) {
            log.debug((Object)"buildInstance() - returning null");
            return null;
        }
        if (targetClass.isPrimitive()) {
            return ReflectionUtils.buildPrimitive(targetClass, value);
        }
        if (ReflectionUtils.isPrimitiveArray(targetClass)) {
            return ReflectionUtils.buildPrimitiveArray(targetClass, value);
        }
        if (targetClass.isAssignableFrom(value.getClass())) {
            return value;
        }
        Constructor<?>[] constructors = targetClass.getConstructors();
        Constructor<?> constructor = null;
        Constructor<?> secondMatchConstructor = null;
        Class valueClass = value.getClass();
        Long longValue = null;
        if (targetClass.equals(class$java$sql$Date == null ? (class$java$sql$Date = ReflectionUtils.class$("java.sql.Date")) : class$java$sql$Date) || targetClass.equals(class$java$util$Date == null ? (class$java$util$Date = ReflectionUtils.class$("java.util.Date")) : class$java$util$Date)) {
            valueClass = class$java$lang$Long == null ? (class$java$lang$Long = ReflectionUtils.class$("java.lang.Long")) : class$java$lang$Long;
            longValue = new Long(((Date)value).getTime());
        }
        for (int i = 0; i < constructors.length; ++i) {
            Constructor<?> c = constructors[i];
            if (c.getParameterTypes().length != 1) continue;
            if (c.getParameterTypes()[0].isAssignableFrom(valueClass)) {
                constructor = c;
                break;
            }
            if (!c.getParameterTypes()[0].equals(class$java$lang$String == null ? ReflectionUtils.class$("java.lang.String") : class$java$lang$String)) continue;
            secondMatchConstructor = c;
        }
        if (constructor == null && secondMatchConstructor == null) {
            throw new NoSuchMethodException("Couldn't find any constructor in class '" + targetClass.getName() + "' that could accept 'java.lang.String' or '" + valueClass.getName() + "' as parameter type");
        }
        if (constructor == null) {
            constructor = secondMatchConstructor;
            value = value.toString();
        }
        if (longValue != null) {
            value = longValue;
        }
        return constructor.newInstance(value);
    }

    public static Object newInstance(Object o) {
        try {
            return o.getClass().newInstance();
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Failed to build new instance of class " + o.getClass() + "because\n" + t);
        }
    }

    public static Object buildNewInstance(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return clazz.newInstance();
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Failed to build new instance of class '" + className + "' because of " + t);
        }
    }

    public static Object invokeStatic(Class target, String methodName, Class[] argClasses, Object[] args) throws Exception {
        Method method = target.getMethod(methodName, argClasses);
        return method.invoke(null, args);
    }

    public static Object invoke(Object target, String methodName, Class[] argClasses, Object[] args) throws Exception {
        Method method = target.getClass().getMethod(methodName, argClasses);
        return method.invoke(target, args);
    }

    public static void invokeInOwnThread(final Object target, final String methodName, final Class[] argClasses, final Object[] args, final String potentialErrorMessage) {
        new Thread(){

            public void run() {
                try {
                    ReflectionUtils.invoke(target, methodName, argClasses, args);
                }
                catch (Throwable t) {
                    log.warn((Object)potentialErrorMessage, t);
                }
            }
        }.start();
    }

    public static void invokeInOwnThread(Object target, String methodName, Class[] argClasses, Object[] args) {
        String potentialErrorMessage = "invoking the method '" + methodName + "' on object of class '" + target.getClass().getName() + "' failed";
        ReflectionUtils.invokeInOwnThread(target, methodName, argClasses, args, potentialErrorMessage);
    }

    public static boolean hasNoParamConstructor(Class c) {
        try {
            c.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }

    public static List listReadWriteFields(Object instance) {
        List cachedResult;
        Class clazz = instance.getClass();
        if (instance instanceof Class) {
            clazz = (Class)instance;
        }
        if ((cachedResult = (List)fieldCache.get(clazz)) != null) {
            return cachedResult;
        }
        ArrayList<Method[]> result = new ArrayList<Method[]>(10);
        Method[] ms = clazz.getMethods();
        for (int i = 0; i < ms.length; ++i) {
            Method getMethod = ms[i];
            Class<?> returnType = getMethod.getReturnType();
            String getMethodName = getMethod.getName();
            if (returnType == null || getMethod.getParameterTypes().length > 1 || !getMethodName.startsWith(GET) && !getMethodName.startsWith(IS)) continue;
            String rawFieldName = getMethodName.substring(3);
            if (getMethodName.startsWith(IS)) {
                rawFieldName = getMethodName.substring(2);
            }
            Method setMethod = null;
            try {
                setMethod = clazz.getMethod(SET + rawFieldName, returnType);
                String sReturnType = "" + setMethod.getReturnType();
                if (!sReturnType.equals("void") && !sReturnType.equals("null")) {
                }
            }
            catch (NoSuchMethodException nsme) {}
            continue;
            result.add(new Method[]{getMethod, setMethod});
        }
        fieldCache.put(instance.getClass(), result);
        return result;
    }

    public static String lookupConstantValue(String constantPath) {
        try {
            int i = constantPath.lastIndexOf(".");
            String className = constantPath.substring(0, i);
            String constantName = constantPath.substring(i + 1);
            Class<?> clazz = Class.forName(className);
            Field fConstant = clazz.getField(constantName);
            return "" + fConstant.get(null);
        }
        catch (Throwable t) {
            log.warn((Object)"extractConstant() failed to determine value", t);
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

