/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import openwfe.org.misc.ByteUtils;
import org.apache.log4j.Logger;

public abstract class Utils {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$Utils == null ? (class$openwfe$org$Utils = Utils.class$("openwfe.org.Utils")) : class$openwfe$org$Utils).getName());
    static /* synthetic */ Class class$openwfe$org$Utils;

    public static byte[] serialize(Serializable object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        oos.flush();
        return baos.toByteArray();
    }

    public static void copy(File file, String destinationPath) {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            int count;
            in = new FileInputStream(file);
            out = new FileOutputStream(destinationPath);
            byte[] buffer = new byte[1024];
            while ((count = in.read(buffer)) >= 1) {
                out.write(buffer, 0, count);
                if (count >= 1024) continue;
                break;
            }
        }
        catch (IOException ie) {
            try {
                in.close();
                out.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            log.warn((Object)("copy() Failed to copy " + file.getPath() + " to " + destinationPath), (Throwable)ie);
        }
    }

    public static void copy(String fileName, String destinationFileName) {
        Utils.copy(new File(fileName), destinationFileName);
    }

    public static void move(File file, String destinationPath) {
        Utils.copy(file, destinationPath);
        boolean b = file.delete();
        if (!b) {
            log.warn((Object)("move() failed to delete file '" + file.getPath() + "' after move."));
        }
    }

    public static void move(String fileName, String destinationFileName) {
        Utils.move(new File(fileName), destinationFileName);
    }

    public static String getMd5Digest(byte[] data) {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsae) {
            log.warn((Object)"cannot compute MD5 digest", (Throwable)nsae);
            return null;
        }
        digest.update(data);
        return ByteUtils.toString(digest.digest());
    }

    public static String getFileProtocolPrefix() {
        if (File.separatorChar == '\\') {
            return "file:/";
        }
        return "file:";
    }

    public static String removeFileProtocolPrefix(String url) {
        String result = url.substring(5);
        if (Utils.getFileProtocolPrefix().length() == 6 && url.startsWith(Utils.getFileProtocolPrefix())) {
            result = url.substring(6);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeFileProtocolPrefix() returning '" + result + "'"));
        }
        return result;
    }

    public static String getCanonicalPath(String applicationDirectory, String path) {
        File f = new File(path);
        if (!f.isAbsolute()) {
            f = new File(applicationDirectory + path);
        }
        try {
            String result = f.getCanonicalPath();
            if (log.isDebugEnabled()) {
                log.debug((Object)("getCanonicalPath() returning " + result));
            }
            return result;
        }
        catch (IOException ie) {
            log.warn((Object)"getCanonicalPath() exception", (Throwable)ie);
            return f.getAbsolutePath();
        }
    }

    public static boolean isUrl(String s) {
        try {
            new URL(s);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public static String expandUrl(String url) {
        return Utils.expandUrl(null, url);
    }

    public static String expandUrl(String applicationDirectory, String url) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("expandUrl() considering >" + url + "<"));
        }
        if (url.startsWith("field:")) {
            return url;
        }
        if (url.startsWith("resource:")) {
            return url;
        }
        if (url.startsWith("file:")) {
            String fn;
            String result = fn = Utils.expandFileName(applicationDirectory, Utils.removeFileProtocolPrefix(url));
            if (fn.indexOf(" ") < 0) {
                result = Utils.getFileProtocolPrefix() + fn;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("expandUrl() 0 returning >" + result + "<"));
            }
            return result;
        }
        if (!Utils.isUrl(url)) {
            return Utils.expandUrl(applicationDirectory, Utils.getFileProtocolPrefix() + url);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("expandUrl() 1 returning >" + url + "<"));
        }
        return url;
    }

    public static URL toUrl(String path) throws MalformedURLException {
        try {
            return new URL(Utils.expandUrl(path));
        }
        catch (MalformedURLException e) {
            File f = new File(path);
            return f.toURI().toURL();
        }
    }

    public static String expandFileName(String applicationDirectory, String filename) {
        String result = null;
        String adir = "";
        if (applicationDirectory != null) {
            adir = applicationDirectory.trim() + File.separator;
        }
        result = File.separatorChar == '\\' ? (filename.charAt(1) == ':' ? filename : adir + filename) : (filename.charAt(0) == File.separatorChar ? filename : adir + filename);
        try {
            result = result.endsWith("*") ? new File(result.substring(0, result.length() - 1)).getCanonicalPath() + File.separatorChar + "*" : new File(result).getCanonicalPath();
        }
        catch (IOException ie) {
            log.warn((Object)"expandFileName() failed to get canonical path", (Throwable)ie);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("expandFileName() returning >" + result + "<"));
        }
        return result;
    }

    public static String ensureProtocol(String url) {
        int colon = (url = url.trim()).indexOf(":");
        if (colon < 0 || colon == 1) {
            return Utils.getFileProtocolPrefix() + url;
        }
        return url;
    }

    public static Set buildFileSet(String rootPath) {
        HashSet result = new HashSet();
        Utils.buildFileSet(result, new File(rootPath));
        return result;
    }

    private static void buildFileSet(Set result, File rootPath) {
        File[] files = rootPath.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (f.isDirectory()) {
                Utils.buildFileSet(result, f);
                continue;
            }
            result.add(f.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean replace(List l, Object thisObject, Object thatObject) {
        List list = l;
        synchronized (list) {
            int index = -1;
            for (int i = 0; i < l.size(); ++i) {
                Object o = l.get(i);
                if (!o.equals(thisObject)) continue;
                index = i;
                break;
            }
            if (index > -1) {
                l.remove(index);
                l.add(index, thatObject);
                return true;
            }
            return false;
        }
    }

    public static String changeToWebPath(String realRootPath, String webRootPath, String pathToChange) {
        pathToChange = pathToChange.substring(realRootPath.length());
        pathToChange = pathToChange.replace('\\', '/');
        if (!webRootPath.endsWith("/") && !pathToChange.startsWith("/")) {
            webRootPath = webRootPath + "/";
        }
        return webRootPath + pathToChange;
    }

    public static void inc(Map map, String key) {
        Utils.inc(map, key, 1);
    }

    public static void inc(Map map, String key, int count) {
        Integer ii = (Integer)map.get(key);
        if (ii == null) {
            ii = new Integer(0);
        }
        ii = new Integer(ii + count);
        map.put(key, ii);
    }

    public static int compareValues(Object value, Object otherValue) {
        try {
            double dVal = Double.parseDouble(value.toString());
            double dOtherVal = Double.parseDouble(otherValue.toString());
            return (int)(dVal - dOtherVal);
        }
        catch (NumberFormatException numberFormatException) {
            return value.toString().compareTo(otherValue.toString());
        }
    }

    public static boolean toBoolean(Object o) {
        if (o == null) {
            return false;
        }
        String s = o.toString().trim();
        return "yes".equalsIgnoreCase(s) || "ok".equalsIgnoreCase(s) || "true".equalsIgnoreCase(s);
    }

    public static String getEncoding() {
        return System.getProperty("openwfe.xml.encoding", "ISO-8859-1");
    }

    public static Charset getCharset() {
        return Charset.forName(Utils.getEncoding());
    }

    public static String copyString(String in) {
        if (in == null) {
            return null;
        }
        return new String(in);
    }

    public static boolean stringEquals(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static void printStackTrace(Throwable t, Writer w) {
        PrintWriter pw = new PrintWriter(w);
        t.printStackTrace(pw);
        pw.flush();
    }

    public static String stackTraceToString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    public static void debugMap(Logger log, Map map) {
        if (!log.isDebugEnabled()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("\n*** debugMap ***\n");
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object value = map.get(key);
            sb.append("   * ");
            sb.append(key);
            sb.append("   -->  ");
            sb.append(value);
            sb.append("\n");
        }
        log.debug((Object)sb.toString());
    }

    public static String getTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String dump(String prefix, byte[] data) {
        try {
            File tempFile = File.createTempFile(prefix, ".dmp");
            if (log.isDebugEnabled()) {
                log.debug((Object)("dump() to " + tempFile.getPath()));
            }
            FileOutputStream fos = new FileOutputStream(tempFile);
            fos.write(data);
            fos.flush();
            fos.close();
            return tempFile.getPath();
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("dump() failure " + t));
            }
            return null;
        }
    }

    public static String ensureForFileName(String in) {
        return in.replaceAll(" ", "_");
    }

    public static void logStackTrace(Logger log, String message) {
        try {
            throw new Exception("openwfe.org.Utils.logStackTrace()");
        }
        catch (Exception e) {
            log.info((Object)message, (Throwable)e);
            return;
        }
    }

    public static void logStackTrace(Logger log) {
        Utils.logStackTrace(log, "logStackTrace()");
    }

    public static Map copyHashMap(Map m) {
        if (m == null) {
            return null;
        }
        HashMap copy = new HashMap(m.size());
        copy.putAll(m);
        return copy;
    }

    public static Object getFirstElementOfClass(List l, Class clazz) {
        Iterator it = l.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!clazz.isAssignableFrom(o.getClass())) continue;
            return o;
        }
        return null;
    }

    public static Object getLastElementOfClass(List l, Class clazz) {
        for (int i = l.size(); i > 0; --i) {
            Object o = l.get(i - 1);
            if (!clazz.isAssignableFrom(o.getClass())) continue;
            return o;
        }
        return null;
    }

    public static long getLastModified(String url) {
        try {
            return Utils.getLastModified(Utils.toUrl(url));
        }
        catch (Throwable t) {
            log.info((Object)("getLastModified() failure for " + url), t);
            return -1L;
        }
    }

    public static long getLastModified(URL u) {
        try {
            return u.openConnection().getLastModified();
        }
        catch (Throwable t) {
            log.info((Object)"getLastModified() failure", t);
            return -1L;
        }
    }

    public static String[] toStringArray(List l) {
        if (l == null) {
            return null;
        }
        String[] ss = new String[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            ss[i] = l.get(i).toString();
        }
        return ss;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

