/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.auth.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.ReflectionUtils;
import openwfe.org.ServiceException;
import openwfe.org.auth.AuthException;
import openwfe.org.auth.Grant;
import openwfe.org.auth.Passwd;
import openwfe.org.auth.PasswdCodec;
import openwfe.org.auth.Permission;
import openwfe.org.auth.Principal;
import openwfe.org.sql.SqlParameters;
import openwfe.org.sql.SqlUtils;
import openwfe.org.sql.ds.OwfeDataSource;
import org.apache.log4j.Logger;

public class SqlPasswdCodec
implements PasswdCodec {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$auth$sql$SqlPasswdCodec == null ? (class$openwfe$org$auth$sql$SqlPasswdCodec = SqlPasswdCodec.class$("openwfe.org.auth.sql.SqlPasswdCodec")) : class$openwfe$org$auth$sql$SqlPasswdCodec).getName());
    protected static final String T_GRANTED = "pgranted";
    protected static final String T_GRANT = "pgrant";
    protected static final String T_PARAMETER = "pparameter";
    protected static final String C_NAME = "name";
    protected static final String C_CODEBASE = "codebase";
    protected static final String C_USERNAME = "username";
    protected static final String C_GRANTNAME = "grantname";
    protected static final String G_PRINCIPAL = "principal";
    protected static final String G_PERMISSION = "permission";
    protected final SqlParameters sqlParams = new SqlParameters("pparameter", "pid", "pgroup", "pkey", "pval");
    private ApplicationContext context = null;
    private Map serviceParams = null;
    static /* synthetic */ Class class$openwfe$org$auth$sql$SqlPasswdCodec;

    public void init(ApplicationContext context, Map serviceParams) {
        this.context = context;
        this.serviceParams = serviceParams;
    }

    public void encodePasswd(Passwd p) throws AuthException {
        Iterator it;
        OwfeDataSource ds = null;
        try {
            ds = SqlUtils.lookupDataSource(this.context, this.serviceParams);
        }
        catch (ServiceException se) {
            throw new AuthException("didn't find data source", se);
        }
        Statement st = null;
        try {
            st = ds.getConnection().createStatement();
            st.execute("DELETE FROM pgranted");
            st.execute("DELETE FROM pgrant");
            st.execute("DELETE FROM pparameter");
        }
        catch (SQLException se) {
            SqlUtils.closeStatement(st);
            throw new AuthException("Failed to clean tables", se);
        }
        try {
            it = p.getPrincipalMap().values().iterator();
            while (it.hasNext()) {
                Principal principal = (Principal)it.next();
                this.encodePrincipal(ds.getConnection(), principal);
            }
        }
        catch (SQLException se) {
            throw new AuthException("Failed to insert principal parameters", se);
        }
        try {
            it = p.getGrantMap().values().iterator();
            while (it.hasNext()) {
                Grant g = (Grant)it.next();
                this.encodeGrant(ds.getConnection(), g);
            }
        }
        catch (SQLException se) {
            throw new AuthException("Failed to insert grants", se);
        }
        ds.releaseConnection();
    }

    public Passwd decodePasswd(Object o) throws AuthException {
        return this.decodePasswd(null);
    }

    public Passwd decodePasswd() throws AuthException {
        OwfeDataSource ds = null;
        try {
            ds = SqlUtils.lookupDataSource(this.context, this.serviceParams);
        }
        catch (ServiceException se) {
            throw new AuthException("didn't find data source", se);
        }
        try {
            Passwd se = new Passwd("passwd", this.decodePrincipals(ds.getConnection()), this.decodeGrants(ds.getConnection()));
            return se;
        }
        catch (Exception e) {
            throw new AuthException("failed to load passwd info", e);
        }
        finally {
            ds.releaseConnection();
        }
    }

    protected List decodePrincipals(Connection con) throws Exception {
        List rawPrincipals = this.sqlParams.extractParameters(con, G_PRINCIPAL, C_NAME);
        ArrayList<Principal> principals = new ArrayList<Principal>(rawPrincipals.size());
        Iterator it = rawPrincipals.iterator();
        while (it.hasNext()) {
            Map params = (Map)it.next();
            Principal principal = (Principal)ReflectionUtils.initObject(params);
            principals.add(principal);
        }
        this.decodeGranted(con, principals);
        return principals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decodeGranted(Connection con, List principals) throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ");
        sb.append(C_USERNAME);
        sb.append(", ");
        sb.append(C_GRANTNAME);
        sb.append(" FROM ");
        sb.append(T_GRANTED);
        String query = sb.toString();
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.createStatement();
            rs = st.executeQuery(query);
            while (rs.next()) {
                Principal principal;
                String username = rs.getString(1);
                String grantname = rs.getString(2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("decodeGranted() looking for >" + username + "<"));
                }
                if ((principal = this.getPrincipal(principals, username)) == null) {
                    log.warn((Object)("decodeGranted() username >" + username + "< not found. Skipping grant."));
                    continue;
                }
                principal.addGrant(grantname);
            }
        }
        catch (Throwable throwable) {
            SqlUtils.closeStatement(st, rs);
            throw throwable;
        }
        SqlUtils.closeStatement(st, rs);
    }

    protected Principal getPrincipal(List principals, String username) {
        Iterator it = principals.iterator();
        while (it.hasNext()) {
            Principal p = (Principal)it.next();
            if (!p.getName().equals(username)) continue;
            return p;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map decodeGrants(Connection con) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ");
        sb.append(C_NAME);
        sb.append(", ");
        sb.append(C_CODEBASE);
        sb.append(" FROM ");
        sb.append(T_GRANT);
        String query = sb.toString();
        HashMap<String, Grant> grants = new HashMap<String, Grant>();
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.createStatement();
            rs = st.executeQuery(query);
            while (rs.next()) {
                String grantName = rs.getString(1);
                String codebase = rs.getString(2);
                Grant g = new Grant(grantName, codebase);
                grants.put(grantName, g);
            }
        }
        catch (Throwable throwable) {
            SqlUtils.closeStatement(st, rs);
            throw throwable;
        }
        SqlUtils.closeStatement(st, rs);
        this.decodePermissions(con, grants);
        return grants;
    }

    protected void decodePermissions(Connection con, Map grants) throws Exception {
        List rawPermissions = this.sqlParams.extractParameters(con, G_PERMISSION, C_GRANTNAME);
        Iterator it = rawPermissions.iterator();
        while (it.hasNext()) {
            Map params = (Map)it.next();
            String className = (String)params.get("class");
            Class<?> permissionClass = Class.forName(className);
            Permission permission = (Permission)ReflectionUtils.buildInstance(permissionClass, params);
            Grant grant = (Grant)grants.get((String)params.get(C_GRANTNAME));
            grant.addPermission(permission);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encodePrincipal(Connection con, Principal principal) throws SQLException {
        long id = this.sqlParams.insertParams(con, G_PRINCIPAL, principal.getInitParameters());
        Statement st = null;
        try {
            Iterator it = principal.getGrants().iterator();
            while (it.hasNext()) {
                String grantName = (String)it.next();
                StringBuffer sb = new StringBuffer();
                sb.append("INSERT INTO ");
                sb.append(T_GRANTED);
                sb.append(" (");
                sb.append(C_USERNAME);
                sb.append(", ");
                sb.append(C_GRANTNAME);
                sb.append(") VALUES (");
                sb.append(SqlUtils.prepareString(principal.getName()));
                sb.append(", ");
                sb.append(SqlUtils.prepareString(grantName));
                sb.append(")");
                String sInsert = sb.toString();
                st = con.createStatement();
                st.execute(sInsert);
            }
        }
        finally {
            SqlUtils.closeStatement(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encodeGrant(Connection con, Grant grant) throws SQLException {
        Statement st = null;
        try {
            String codebase = grant.getUrl();
            if (log.isDebugEnabled()) {
                log.debug((Object)("encodeGrant() codebase is >" + codebase + "<"));
            }
            StringBuffer sb = new StringBuffer();
            sb.append("INSERT INTO ");
            sb.append(T_GRANT);
            sb.append(" (");
            sb.append(C_NAME);
            sb.append(", ");
            sb.append(C_CODEBASE);
            sb.append(") VALUES (");
            sb.append(SqlUtils.prepareString(grant.getName()));
            sb.append(", ");
            sb.append(SqlUtils.prepareString(codebase));
            sb.append(")");
            String sInsert = sb.toString();
            st = con.createStatement();
            st.execute(sInsert);
            Enumeration<java.security.Permission> en = grant.getPermissions().elements();
            while (en.hasMoreElements()) {
                Permission permission = (Permission)en.nextElement();
                HashMap<String, String> pParams = new HashMap<String, String>(permission.getParameters().size());
                pParams.put(C_GRANTNAME, grant.getName());
                pParams.put("class", permission.getClass().getName());
                pParams.putAll(permission.getParameters());
                this.sqlParams.insertParams(con, G_PERMISSION, pParams);
            }
        }
        catch (Throwable throwable) {
            SqlUtils.closeStatement(st);
            throw throwable;
        }
        SqlUtils.closeStatement(st);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

