/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.auth.xml;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.Parameters;
import openwfe.org.ReflectionUtils;
import openwfe.org.Utils;
import openwfe.org.auth.AuthException;
import openwfe.org.auth.Grant;
import openwfe.org.auth.Passwd;
import openwfe.org.auth.PasswdCodec;
import openwfe.org.auth.Permission;
import openwfe.org.auth.Principal;
import openwfe.org.auth.xml.XmlPrincipalCodec;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class XmlPasswdCodec
implements PasswdCodec {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$auth$xml$XmlPasswdCodec == null ? (class$openwfe$org$auth$xml$XmlPasswdCodec = XmlPasswdCodec.class$("openwfe.org.auth.xml.XmlPasswdCodec")) : class$openwfe$org$auth$xml$XmlPasswdCodec).getName());
    public static final String NAME = "name";
    public static final String CLASS = "class";
    public static final String GRANT = "grant";
    public static final String PASSWD = "passwd";
    public static final String CODEBASE = "codebase";
    public static final String PRINCIPAL = "principal";
    public static final String PERMISSION = "permission";
    private static final XmlPermissionCodec permissionCodec = new XmlPermissionCodec();
    private static final XmlPrincipalCodec principalCodec = new XmlPrincipalCodec();
    private Element rootElement = null;
    private URL docUrl = null;
    private ApplicationContext context = null;
    private Map serviceParams = null;
    private Passwd decodedPasswd = null;
    private long lastModified = 0L;
    static /* synthetic */ Class class$openwfe$org$auth$xml$XmlPasswdCodec;

    public void init(ApplicationContext context, Map serviceParams) {
        this.context = context;
        this.serviceParams = serviceParams;
    }

    private Object doEncodePasswd(Passwd p) throws AuthException {
        Element ePasswd = new Element(PASSWD);
        ePasswd.setAttribute(NAME, p.getName());
        Iterator it = p.getPrincipalMap().values().iterator();
        while (it.hasNext()) {
            ePasswd.addContent((Content)((Element)principalCodec.encodePrincipal((Principal)it.next(), null, null)));
        }
        it = p.getGrantMap().values().iterator();
        while (it.hasNext()) {
            ePasswd.addContent((Content)this.encodeGrant((Grant)it.next()));
        }
        return ePasswd;
    }

    public void encodePasswd(Passwd p) throws AuthException {
        Element ePasswd = (Element)this.doEncodePasswd(p);
        try {
            String fileName = this.docUrl.toString();
            if (fileName.startsWith("file:")) {
                fileName = fileName.substring(5);
            }
            FileWriter writer = new FileWriter(fileName);
            XMLOutputter out = XmlUtils.getXMLOutputter();
            out.output(new Document(ePasswd), (Writer)writer);
        }
        catch (IOException ie) {
            throw new AuthException("Failed to output passwd back to " + this.docUrl, ie);
        }
    }

    public Passwd decodePasswd() throws AuthException {
        return this.decodePasswd(null);
    }

    public Passwd decodePasswd(Object o) throws AuthException {
        this.docUrl = null;
        try {
            if (o != null) {
                if (o instanceof String) {
                    String rawUrl = (String)o;
                    rawUrl = Utils.expandUrl(this.context.getApplicationDirectory(), rawUrl);
                    this.docUrl = Utils.toUrl(rawUrl);
                } else if (o instanceof URL) {
                    this.docUrl = (URL)o;
                }
            } else if (this.serviceParams != null) {
                String sDocUrl = (String)this.serviceParams.get(PASSWD);
                sDocUrl = Utils.expandUrl(this.context.getApplicationDirectory(), sDocUrl);
                this.docUrl = Utils.toUrl(sDocUrl);
            } else {
                log.error((Object)"decodePasswd() no info for building passwd...");
            }
        }
        catch (MalformedURLException e) {
            throw new AuthException("Cannot extract xml out of object >" + o + "<", e);
        }
        if (this.docUrl == null) {
            throw new AuthException("Cannot turn your >" + o + "< into a Passwd instance.");
        }
        long modified = -1L;
        try {
            URLConnection con = this.docUrl.openConnection();
            modified = con.getLastModified();
        }
        catch (IOException ie) {
            log.warn((Object)("decodePasswd() failed to connect to " + this.docUrl));
        }
        log.debug((Object)("decodePasswd() modified       : " + modified));
        log.debug((Object)("decodePasswd() lastModified   : " + this.lastModified));
        if (this.lastModified < 1L || this.lastModified < modified) {
            log.debug((Object)"decodePasswd() reloading...");
            try {
                this.rootElement = XmlUtils.extractXml(this.docUrl, false);
            }
            catch (Exception e) {
                throw new AuthException("Failed to decode XML document '" + this.docUrl + "'", e);
            }
            this.decodedPasswd = this.decode(this.rootElement);
            this.lastModified = modified;
        }
        return this.decodedPasswd;
    }

    protected Map extractAttributes(Element elt) {
        HashMap<String, String> result = new HashMap<String, String>();
        Iterator it = elt.getAttributes().iterator();
        while (it.hasNext()) {
            Attribute a = (Attribute)it.next();
            result.put(a.getName(), a.getValue());
        }
        return result;
    }

    protected Grant extractGrant(Element elt) throws AuthException {
        String name = elt.getAttributeValue(NAME);
        String url = elt.getAttributeValue(CODEBASE);
        HashSet<Permission> permissions = new HashSet<Permission>();
        Iterator it = elt.getChildren(PERMISSION).iterator();
        while (it.hasNext()) {
            Permission p = permissionCodec.decodePermission((Element)it.next());
            permissions.add(p);
        }
        try {
            return new Grant(name, url, permissions);
        }
        catch (Exception e) {
            throw new AuthException("Failed to extract Grant", e);
        }
    }

    protected Passwd decode(Element elt) throws AuthException {
        if (!elt.getName().equals(PASSWD)) {
            throw new AuthException("Waiting for xml element named 'passwd' not '" + elt.getName() + "'.");
        }
        String name = elt.getAttributeValue(NAME);
        if (name == null) {
            name = PASSWD;
        }
        name = name.trim();
        log.info((Object)("decode() Passwd name is '" + name + "'"));
        ArrayList<Principal> principals = new ArrayList<Principal>(40);
        Iterator it = elt.getChildren(PRINCIPAL).iterator();
        while (it.hasNext()) {
            Principal p = principalCodec.decodePrincipal(null, it.next());
            principals.add(p);
        }
        HashMap<String, Grant> grantMap = new HashMap<String, Grant>();
        it = elt.getChildren(GRANT).iterator();
        while (it.hasNext()) {
            Grant g = null;
            try {
                g = this.extractGrant((Element)it.next());
            }
            catch (AuthException ae) {
                log.warn((Object)"decode() failed to decode a Grant. Skipped it.", (Throwable)ae);
                continue;
            }
            grantMap.put(g.getName(), g);
        }
        return new Passwd(name, principals, grantMap);
    }

    protected Element encodeGrant(Grant grant) {
        Element eGrant = new Element(GRANT);
        eGrant.setAttribute(NAME, grant.getName());
        eGrant.setAttribute(CODEBASE, grant.getUrl());
        Enumeration<java.security.Permission> en = grant.getPermissions().elements();
        while (en.hasMoreElements()) {
            Permission p = (Permission)en.nextElement();
            try {
                Element ePermission = permissionCodec.encodePermission(p);
                eGrant.addContent((Content)ePermission);
            }
            catch (AuthException ae) {
                log.warn((Object)("Failed to encode a Permission of grant '" + grant.getName() + "'"), (Throwable)ae);
            }
        }
        return eGrant;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class XmlPermissionCodec {
        private XmlPermissionCodec() {
        }

        public Element encodePermission(Permission p) throws AuthException {
            Element result = new Element(XmlPasswdCodec.PERMISSION);
            Map params = p.getParameters();
            Iterator it = params.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = (String)params.get(key);
                result.setAttribute(key, value);
            }
            result.setAttribute(XmlPasswdCodec.CLASS, p.getClass().getName());
            return result;
        }

        public Permission decodePermission(Element e) throws AuthException {
            try {
                Map params = Parameters.extractAttributes(e);
                String className = (String)params.get(XmlPasswdCodec.CLASS);
                Class<?> permissionClass = Class.forName(className);
                Permission p = (Permission)ReflectionUtils.buildInstance(permissionClass, params);
                return p;
            }
            catch (Exception ex) {
                throw new AuthException("Failed to decode permission", ex);
            }
        }
    }
}

