/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.crypto;

import java.io.Serializable;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import openwfe.org.crypto.CryptoException;
import openwfe.org.crypto.RsaKey;
import openwfe.org.misc.ByteUtils;

public class SignedObject
implements Serializable {
    private Serializable object = null;
    private String signature = null;

    public SignedObject() {
    }

    public SignedObject(Serializable object, RsaKey privateKey) throws CryptoException {
        this.object = object;
        try {
            Signature sig = Signature.getInstance("MD5withRSA");
            sig.initSign((PrivateKey)((Object)privateKey.assembleRealKey()));
            sig.update(ByteUtils.objectToByteArray(this.object));
            this.signature = ByteUtils.toString(sig.sign());
        }
        catch (Exception e) {
            throw new CryptoException("Failed to sign object", e);
        }
    }

    public Serializable getObject() {
        return this.object;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setObject(Serializable s) {
        this.object = s;
    }

    public void setSignature(String ba) {
        this.signature = ba;
    }

    public boolean verify(RsaKey publicKey) throws CryptoException {
        try {
            Signature sig = Signature.getInstance("MD5withRSA");
            sig.initVerify((PublicKey)((Object)publicKey.assembleRealKey()));
            sig.update(ByteUtils.objectToByteArray(this.object));
            return sig.verify(ByteUtils.fromString(this.signature));
        }
        catch (Exception e) {
            throw new CryptoException("Failed to verify signed object", e);
        }
    }
}

