/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.misc;

import java.util.ArrayList;
import java.util.List;

public class ArgParser {
    private char quote = (char)39;

    public ArgParser() {
    }

    public ArgParser(char quote) {
        this.quote = quote;
    }

    public String[] parse(String rawArgs) {
        String raw = rawArgs.trim();
        if (raw == null || raw.length() < 1) {
            return new String[0];
        }
        Object result = null;
        result = raw.indexOf(this.quote) < 0 ? this.parseWithoutQuote(raw) : this.parse(new ArrayList(7), raw);
        if (result instanceof String[]) {
            return (String[])result;
        }
        List l = (List)result;
        String[] args = new String[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            args[i] = (String)l.get(i);
        }
        return args;
    }

    private List parse(List l, String raw) {
        int i;
        if (raw == null || raw.length() < 1) {
            return l;
        }
        boolean backslashed = false;
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < raw.length(); ++i) {
            char c = raw.charAt(i);
            if (i == 0 && c == this.quote) continue;
            if (c == '\\' && !backslashed) {
                backslashed = true;
                continue;
            }
            if (backslashed) {
                if (c != this.quote) {
                    sb.append('\\');
                }
                sb.append(c);
                backslashed = false;
                continue;
            }
            if (c == this.quote) break;
            sb.append(c);
        }
        String arg = sb.toString();
        l.add(sb.toString());
        if (i >= raw.length()) {
            return l;
        }
        String nextRaw = raw.substring(i + 1).trim();
        int q = nextRaw.indexOf(this.quote);
        if (q > -1) {
            nextRaw = nextRaw.substring(q + 1);
        }
        return this.parse(l, nextRaw);
    }

    private Object parseWithoutQuote(String raw) {
        if (raw.indexOf(",") > -1) {
            return raw.split(",\\s*");
        }
        return this.trim(raw.split("\\s+"));
    }

    private List trim(String[] ss) {
        ArrayList<String> l = new ArrayList<String>(ss.length);
        for (int i = 0; i < ss.length; ++i) {
            String s = ss[i].trim();
            if (s.length() < 1) continue;
            l.add(s);
        }
        return l;
    }
}

