/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.misc;

import java.beans.XMLEncoder;
import java.io.ByteArrayOutputStream;
import openwfe.org.misc.ByteException;

public abstract class ByteUtils {
    public static byte[] objectToByteArray(Object o) throws ByteException {
        return ByteUtils.objectsToByteArray(new Object[]{o});
    }

    public static byte[] objectsToByteArray(Object[] objects) throws ByteException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        XMLEncoder encoder = new XMLEncoder(os);
        try {
            for (int i = 0; i < objects.length; ++i) {
                if (objects[i] == null) continue;
                encoder.writeObject(objects[i]);
                encoder.flush();
            }
        }
        catch (Throwable t) {
            throw new ByteException("Failed to encode objects", t);
        }
        return os.toByteArray();
    }

    public static String toString(byte[] ba) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ba.length; ++i) {
            if (ba[i] >= 0) {
                sb.append('+');
            }
            sb.append(ba[i]);
        }
        return sb.toString();
    }

    public static int toByte(String s) {
        if (s.charAt(0) == '+') {
            s = s.substring(1);
        }
        return Integer.parseInt(s);
    }

    public static byte[] fromString(String s) throws NumberFormatException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        String currentByte = "" + s.charAt(0);
        for (int i = 1; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '+' || c == '-') {
                os.write(ByteUtils.toByte(currentByte));
                currentByte = "" + c;
                continue;
            }
            currentByte = currentByte + c;
        }
        os.write(ByteUtils.toByte(currentByte));
        return os.toByteArray();
    }
}

