/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.misc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;

public class Wget {
    public static final int READ_BUFFER_SIZE = 2048;
    public static final String BANNER = "OpenWFE Wget 0.0.5 - simple java wget";
    public static final int MAX_RETRIES = 42;
    static /* synthetic */ Class class$openwfe$org$misc$Wget;

    public static boolean wget(String downloadDir, String sUrl) throws Exception {
        return Wget.wget(downloadDir, sUrl, false, false);
    }

    public static boolean wget(String downloadDir, String sUrl, boolean head, boolean verbose) throws Exception {
        if (!downloadDir.endsWith(File.separator)) {
            downloadDir = downloadDir + File.separator;
        }
        int i = sUrl.lastIndexOf("/");
        String fileName = sUrl.substring(i + 1);
        fileName = downloadDir + fileName;
        File targetFile = new File(fileName);
        URL url = new URL(sUrl);
        URLConnection con = url.openConnection();
        if (head && targetFile.exists() && verbose) {
            System.out.println("..wget() local   " + targetFile.lastModified());
            System.out.println("..wget() remote  " + con.getLastModified());
        }
        if (head && targetFile.exists() && targetFile.lastModified() >= con.getLastModified()) {
            if (verbose) {
                System.out.println("..wget() local file fresher than web version. Not downloading.");
            }
            return false;
        }
        if (verbose) {
            System.out.println("..wget() will save to " + fileName);
        }
        int contentLength = con.getContentLength();
        if (verbose) {
            System.out.println("..wget() contentLength is " + contentLength);
        }
        if (contentLength < 0) {
            contentLength = Integer.MAX_VALUE;
        }
        InputStream is = url.openStream();
        FileOutputStream fos = new FileOutputStream(fileName);
        byte[] buffer = new byte[2048];
        int totalRead = 0;
        int retries = 0;
        while (true) {
            int read = is.read(buffer);
            totalRead += read;
            if (verbose) {
                System.out.println("..wget() read " + read + " bytes   (" + totalRead + "/" + contentLength + ") r" + retries);
            }
            if (read > 0) {
                fos.write(buffer, 0, read);
                fos.flush();
                retries = 0;
            }
            if (totalRead >= contentLength) break;
            if (read >= 2048) continue;
            if (retries >= 42) {
                if (!verbose) break;
                System.out.println("..wget() giving up.");
                break;
            }
            if (read >= 1) continue;
            Thread.yield();
            ++retries;
        }
        fos.close();
        is.close();
        return true;
    }

    private static void mkdir(String dir, boolean verbose) throws Exception {
        File f = new File(dir);
        if (f.exists() && !f.isDirectory()) {
            throw new IllegalArgumentException("dir '" + dir + "' already exists and it's not a directory.");
        }
        if (f.exists()) {
            if (verbose) {
                System.out.println("..wget() dir '" + dir + "' already present");
            }
            return;
        }
        f.mkdirs();
        if (verbose) {
            System.out.println("..wget() made dir '" + dir + "'");
        }
    }

    public static void downloadList(String downloadListUrl, boolean head, boolean verbose) throws Exception {
        String line;
        if (downloadListUrl.indexOf("://") < 0) {
            downloadListUrl = "file:" + downloadListUrl;
        }
        URL dUrl = new URL(downloadListUrl);
        URLConnection con = dUrl.openConnection();
        BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream()));
        String server = null;
        while ((line = br.readLine()) != null) {
            boolean b;
            if ((line = line.trim()).length() < 1 || line.startsWith("#")) continue;
            if (line.startsWith("mkdir ")) {
                Wget.mkdir(line.substring(6).trim(), verbose);
                continue;
            }
            if (line.startsWith("server")) {
                server = line.trim().length() == 6 ? null : line.substring(7).trim();
                if (server == null || server.endsWith("/")) continue;
                server = server + "/";
                continue;
            }
            int i = line.indexOf(" ");
            String downloadDir = ".";
            String urlToDownload = line;
            if (i > -1) {
                downloadDir = line.substring(0, i).trim();
                urlToDownload = line.substring(i + 1).trim();
            }
            if (server != null && urlToDownload.indexOf("://") < 1) {
                urlToDownload = server + urlToDownload;
            }
            if (verbose) {
                System.out.println("..wget() todir >" + downloadDir + "<  fromURL >" + urlToDownload + "<");
            }
            if (b = Wget.wget(downloadDir, urlToDownload, head, verbose)) {
                System.out.println("x " + urlToDownload);
                continue;
            }
            System.out.println(". " + urlToDownload);
        }
    }

    private static void printUsage() {
        String cmd = "java " + (class$openwfe$org$misc$Wget == null ? (class$openwfe$org$misc$Wget = Wget.class$("openwfe.org.misc.Wget")) : class$openwfe$org$misc$Wget).getName();
        System.out.println();
        System.out.println(BANNER);
        System.out.println();
        System.out.println("USAGE :");
        System.out.println();
        System.out.print(cmd);
        System.out.println(" [-d {downloadDir}] [-v] [-H] {URL}*");
        System.out.println(" [-v] [-H] -l {URL of a download list}");
        System.out.println();
        System.out.println("Wget is a java 'wget', with not much features.");
        System.out.println();
        System.out.println("  -v : verbose");
        System.out.println("  -h : prints this usage and exits");
        System.out.println("  -H : HEAD, will not download if local resource fresher than web resource");
        System.out.println("  -l : the files and their target dir are enumerated in a list");
        System.out.println("       (behind a URL or within a local file)");
        System.out.println();
        System.exit(-1);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            Wget.printUsage();
        }
        boolean head = false;
        boolean verbose = false;
        int index = 0;
        String downloadDir = ".";
        String downloadList = null;
        while (index < args.length && args[index].startsWith("-")) {
            if (args[index].equals("-d")) {
                if (args.length - index < 2) {
                    Wget.printUsage();
                }
                downloadDir = args[index + 1];
                index += 2;
                continue;
            }
            if (args[index].equals("-v")) {
                verbose = true;
                ++index;
                continue;
            }
            if (args[index].equals("-H")) {
                head = true;
                ++index;
                continue;
            }
            if (args[index].equals("-h")) {
                Wget.printUsage();
                continue;
            }
            if (!args[index].equals("-l")) continue;
            downloadList = args[index + 1];
            index += 2;
        }
        if (downloadList != null) {
            System.out.println("...downloadList is at " + downloadList);
            Wget.downloadList(downloadList, head, verbose);
            System.exit(0);
        }
        for (int i = index; i < args.length; ++i) {
            Wget.wget(downloadDir, args[i], head, verbose);
            System.out.println("...got " + args[i]);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

