/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Map;
import openwfe.org.AbstractService;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import org.apache.log4j.Logger;

public abstract class SocketService
extends AbstractService {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$net$SocketService == null ? (class$openwfe$org$net$SocketService = SocketService.class$("openwfe.org.net.SocketService")) : class$openwfe$org$net$SocketService).getName());
    public static final String P_PORT = "port";
    public static final String P_INET_ADDRESS = "inetAddress";
    private int port = -1;
    private int defaultPort = 7000;
    static /* synthetic */ Class class$openwfe$org$net$SocketService;

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        super.init(serviceName, context, serviceParams);
        this.port = MapUtils.getAsInt(serviceParams, P_PORT, this.getDefaultPort());
        if (log.isDebugEnabled()) {
            log.debug((Object)("init() listening on port " + this.port));
        }
        InetAddress inetAddress = null;
        String sInetAddress = MapUtils.getAsString(serviceParams, P_INET_ADDRESS);
        if (sInetAddress != null) {
            try {
                inetAddress = InetAddress.getByName(sInetAddress);
            }
            catch (Exception e) {
                log.info((Object)("Cannot resolve '" + sInetAddress + "' to an inet address, listening on all interfaces"), (Throwable)e);
            }
        }
        try {
            ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
            serverSocketChannel.socket().bind(new InetSocketAddress(inetAddress, this.port));
            serverSocketChannel.configureBlocking(false);
            final Selector selector = Selector.open();
            serverSocketChannel.register(selector, 16);
            new Thread(){

                public void run() {
                    while (SocketService.this.isRunning()) {
                        try {
                            int n = selector.select();
                            if (n == 0) continue;
                            Iterator<SelectionKey> it = selector.selectedKeys().iterator();
                            while (it.hasNext()) {
                                SelectionKey key = it.next();
                                if (key.isAcceptable()) {
                                    ServerSocketChannel ssc = (ServerSocketChannel)key.channel();
                                    SocketChannel sc = ssc.accept();
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)("Incoming connection: " + SocketService.prettyPrintSocket(sc.socket())));
                                    }
                                    SocketService.registerChannel(selector, sc, 1);
                                    log.debug((Object)"channel registered.");
                                }
                                if (key.isReadable()) {
                                    SocketService.this.handle(key);
                                }
                                it.remove();
                            }
                        }
                        catch (Throwable t) {
                            log.info((Object)"Handling of a socket failed", t);
                        }
                    }
                }
            }.start();
        }
        catch (Throwable t) {
            log.warn((Object)"Socket handling failed. Service stopped.", t);
        }
    }

    private static String prettyPrintSocket(Socket socket) {
        StringBuffer sb = new StringBuffer();
        sb.append("remote ");
        sb.append(socket.getInetAddress());
        sb.append(":");
        sb.append(socket.getPort());
        sb.append(" <--> local ");
        sb.append(socket.getLocalAddress());
        sb.append(":");
        sb.append(socket.getLocalPort());
        return sb.toString();
    }

    private static void registerChannel(Selector selector, SelectableChannel channel, int operations) throws IOException {
        if (channel == null) {
            return;
        }
        channel.configureBlocking(false);
        channel.register(selector, operations);
    }

    public int getPort() {
        return this.port;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public void setDefaultPort(int port) {
        this.defaultPort = port;
    }

    public abstract void handle(SelectionKey var1) throws ServiceException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

