/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.rmi;

import java.rmi.ConnectException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import openwfe.org.rmi.LocalRemoteService;
import openwfe.org.state.StoppedState;
import org.apache.log4j.Logger;

public class RemoteService
extends LocalRemoteService {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$rmi$RemoteService == null ? (class$openwfe$org$rmi$RemoteService = RemoteService.class$("openwfe.org.rmi.RemoteService")) : class$openwfe$org$rmi$RemoteService).getName());
    public static final String PORT = "port";
    private Registry registry = null;
    static /* synthetic */ Class class$openwfe$org$rmi$RemoteService;

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        super.init(serviceName, context, serviceParams);
        this.localInit();
        int port = MapUtils.getAsInt(this.getParams(), PORT, 1099);
        try {
            this.registry = LocateRegistry.getRegistry(port);
            try {
                this.registry.rebind(this.getRemoteName(), this.getRemote());
            }
            catch (ConnectException ce) {
                this.registry = LocateRegistry.createRegistry(port);
                this.registry.rebind(this.getRemoteName(), this.getRemote());
            }
            log.info((Object)("init() Service bound in rmi registry " + port + " under name '" + this.getRemoteName() + "'"));
        }
        catch (Exception e) {
            log.warn((Object)("init() Failed to bind an remote instance under name '" + this.getRemoteName() + "' on port " + port), (Throwable)e);
            throw new ServiceException("Failed to bind an remote instance under name '" + this.getRemoteName() + "' on port " + port);
        }
        log.info((Object)("Serving on rmi port " + port));
    }

    public void stop() throws ServiceException {
        this.setState(new StoppedState());
        try {
            this.registry.unbind(this.getRemoteName());
        }
        catch (Exception e) {
            log.info((Object)"stop() Something wicked happened during unbind", (Throwable)e);
            return;
        }
        log.info((Object)("stop() Unbound server '" + this.getRemoteName() + "'"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

