/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.rmi.session;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.Service;
import openwfe.org.ServiceException;
import openwfe.org.Utils;
import openwfe.org.rmi.session.RunnableWorkSessionServer;
import org.apache.log4j.Logger;

public abstract class ClassedWorkSessionServer
extends RunnableWorkSessionServer {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$rmi$session$ClassedWorkSessionServer == null ? (class$openwfe$org$rmi$session$ClassedWorkSessionServer = ClassedWorkSessionServer.class$("openwfe.org.rmi.session.ClassedWorkSessionServer")) : class$openwfe$org$rmi$session$ClassedWorkSessionServer).getName());
    public static final String P_REMOTE_SESSION_IMPL_CLASS = "remoteSessionImplClass";
    public static final String P_SUBJECT = "__subject__";
    private Class sessionImplClass = null;
    static /* synthetic */ Class class$openwfe$org$rmi$session$ClassedWorkSessionServer;
    static /* synthetic */ Class class$openwfe$org$Service;

    public void init(String serviceName, ApplicationContext context, Map serviceParams) throws ServiceException {
        super.init(serviceName, context, serviceParams);
        String remoteSessionImplClassName = MapUtils.getMandatoryString(serviceParams, P_REMOTE_SESSION_IMPL_CLASS);
        try {
            this.sessionImplClass = Class.forName(remoteSessionImplClassName);
        }
        catch (Throwable t) {
            throw new ServiceException("Failed to load sessionImplClass '" + remoteSessionImplClassName + "'", t);
        }
        log.info((Object)("init() RemoteSessionImplClass set to '" + remoteSessionImplClassName + "'"));
    }

    protected Class getSessionImplClass() {
        return this.sessionImplClass;
    }

    protected Remote newRemoteSession(Object subject) throws ServiceException, RemoteException {
        Remote session = null;
        try {
            session = (Remote)this.getSessionImplClass().newInstance();
        }
        catch (Throwable t) {
            throw new RemoteException("Failed to instantiate session of class '" + this.getSessionImplClass().getName() + "'", t);
        }
        if (session instanceof Service) {
            String sessionName = this.getName() + "_session_" + session.toString();
            Map sessionParams = Utils.copyHashMap(this.getParams());
            sessionParams.put(P_SUBJECT, subject);
            ((Service)((Object)session)).init(sessionName, this.getContext(), sessionParams);
        } else {
            log.info((Object)("newRemoteSession() session of class '" + this.sessionImplClass.getName() + "' doesn't extend '" + (class$openwfe$org$Service == null ? (class$openwfe$org$Service = ClassedWorkSessionServer.class$("openwfe.org.Service")) : class$openwfe$org$Service).getName() + "'"));
        }
        return session;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

