/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.time;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class Time {
    public static final SimpleDateFormat SDF_ISO_DATE = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
    public static final SimpleDateFormat SDF_ISO_DATE_SHORT = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat[] dateFormats = new SimpleDateFormat[]{SDF_ISO_DATE, SDF_ISO_DATE_SHORT, new SimpleDateFormat("yy-MM-dd HH:mm:ss"), new SimpleDateFormat("dd-MM-yy"), new SimpleDateFormat("dd-MM-yy HH:mm:ss")};

    public static long parseTimeString(String time) {
        time = time.trim();
        int index = -1;
        long result = 0L;
        String number = "";
        while (true) {
            if (++index >= time.length()) {
                if (number.length() <= 0) break;
                result += (long)Integer.parseInt(number);
                break;
            }
            char c = time.charAt(index);
            if (Character.isDigit(c)) {
                number = number + c;
                continue;
            }
            long value = Long.parseLong(number);
            number = "";
            if (c == 'y') {
                result += value * 365L * 24L * 3600L * 1000L;
                continue;
            }
            if (c == 'M') {
                result += value * 30L * 24L * 3600L * 1000L;
                continue;
            }
            if (c == 'w') {
                result += value * 7L * 24L * 3600L * 1000L;
                continue;
            }
            if (c == 'd') {
                result += value * 24L * 3600L * 1000L;
                continue;
            }
            if (c == 'h') {
                result += value * 3600L * 1000L;
                continue;
            }
            if (c == 'm') {
                result += value * 60L * 1000L;
                continue;
            }
            if (c == 's') {
                result += value * 1000L;
                continue;
            }
            result += value;
        }
        return result;
    }

    private static long[] tts(long time, int divisor) {
        long l0 = time % (long)divisor;
        long l1 = (time - l0) / (long)divisor;
        return new long[]{l0, l1};
    }

    public static String toTimeString(Long time, boolean showMillis) {
        if (time == null) {
            return "0ms";
        }
        return Time.toTimeString((long)time, showMillis);
    }

    public static String toTimeString(long time, boolean showMillis) {
        long[] ll = Time.tts(time, 1000);
        long ms = ll[0];
        ll = Time.tts(ll[1], 60);
        long s = ll[0];
        ll = Time.tts(ll[1], 60);
        long m = ll[0];
        ll = Time.tts(ll[1], 24);
        long h = ll[0];
        ll = Time.tts(ll[1], 30);
        long d = ll[0];
        ll = Time.tts(ll[1], 12);
        long M = ll[0];
        long y = ll[1];
        StringBuffer sb = new StringBuffer();
        if (y > 0L) {
            sb.append(y).append("y");
        }
        if (M > 0L) {
            sb.append(M).append("M");
        }
        if (d > 0L) {
            sb.append(d).append("d");
        }
        if (h > 0L) {
            sb.append(h).append("h");
        }
        if (m > 0L) {
            sb.append(m).append("m");
        }
        if (s > 0L) {
            sb.append(s).append("s");
        }
        if (showMillis) {
            sb.append(ms).append("ms");
        }
        return sb.toString();
    }

    public static Date parseDate(String s) {
        if (s == null) {
            return null;
        }
        String sDate = s.trim();
        sDate = sDate.replace('/', '-');
        sDate = sDate.replace('.', '-');
        for (int i = 0; i < dateFormats.length; ++i) {
            try {
                Date d = dateFormats[i].parse(sDate);
                return d;
            }
            catch (Throwable throwable) {
                continue;
            }
        }
        return null;
    }

    public static String toIsoDate(long time) {
        Date d = new Date(time);
        return SDF_ISO_DATE.format(d);
    }

    public static String toIsoDate(Date d) {
        return SDF_ISO_DATE.format(d);
    }

    public static String toIsoDate() {
        return Time.toIsoDate(System.currentTimeMillis());
    }

    public static long fromIsoDate(String sDate) throws ParseException {
        return SDF_ISO_DATE.parse(sDate).getTime();
    }
}

