/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: Passwd.java 2910 2006-07-03 13:43:48Z jmettraux $
 */

//
// Passwd.java
//
// jmettraux@openwfe.org
//
// made in the CreveCoeur
//
// generated with 
// jtmpl 1.0.04 31.10.2002 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.auth;

import java.security.ProtectionDomain;
import java.security.Permissions;
import java.security.PermissionCollection;
import javax.security.auth.Subject;


/**
 * Encapsulating authentification and authorizations.
 *
 * <p>
 * <b>Important note</b><br>
 * Log ouptut for Passwd and PolicyService has been commented out, it
 * induced stack overflow errors when log4j was rotating its log files (and
 * thus requesting this PolicyService for filepermissions).<br>
 * Feel free to comment in log output, but beware to comment it out for
 * production builds.
 * </p>
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Date: 2006-07-03 15:43:48 +0200 (Mon, 03 Jul 2006) $
 * <br>$Id: Passwd.java 2910 2006-07-03 13:43:48Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class Passwd
{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(Passwd.class.getName());

    //
    // FIELDS

    private String name = null;
        
    private java.util.Map grantMap = null;

    private java.util.Map principalMap = null;
    private java.util.List principalList = null;
        // principals archetypes are stored by their names
        // and as a list

    //
    // CONSTRUCTORS

    public Passwd
        (final String name, 
         final java.util.List principalList,
         final java.util.Map grantMap)
    {
        this.name = name;
        this.principalList = principalList;
        this.grantMap = grantMap;

        buildPrincipalMap();
    }

    //
    // METHODS

    public String getName ()
    {
        return this.name;
    }

    public java.util.Map getPrincipalMap ()
    {
        return this.principalMap;
    }

    public java.util.Map getGrantMap ()
    {
        return this.grantMap;
    }

    public Principal authentify 
        (final String principalName, final Object credentials)
    throws 
        AuthException
    {
        Principal p = (Principal)this.principalMap.get(principalName);

        if (p == null)
        {
            if (log.isDebugEnabled())
            {
                log.debug
                    ("No principal named '"+principalName+"' found in map");
            }

            final java.util.Iterator it = this.principalList.iterator();
            while (it.hasNext())
            {
                final Principal ip = (Principal)it.next();
                
                if (principalName.matches(ip.getName()))
                {
                    p = ip;
                    break;
                }
            }

            if (p == null)
            {
                throw new AuthException
                    ("No principal named '"+principalName+"' found");
            }
        }

        if (log.isDebugEnabled())
            log.debug("authentify() is p a copy ? "+p.isCopy());

        if ( ! p.authentify(credentials))
        {
            log.debug("authentify() authentication failed.");
            return null;
        }

        return p.getWorkCopy();
    }

    /*
     * extracts the Principal this class cares about
     */
    private Principal extractsEffectivePrincipal (ProtectionDomain domain)
        throws AuthException
    {
        java.security.Principal[] principals = domain.getPrincipals();
        for (int i=0; i<principals.length; i++)
        {
            final Principal principal = (Principal)principals[i];
            final Class pClass = principal.getClass();

            //log.debug("extractsEffectivePrincipal() pClass is "+pClass);

            if (Principal.class.isAssignableFrom(pClass))
            {
                //log.debug
                //    ("extractsEffectivePrincipal() returning class "+
                //     pClass.getName());
                //log.debug
                //    ("extractsEffectivePrincipal() returning principal "+
                //     principal.getName());

                return principal;
            }
        }

        //log.debug("extractsEffectivePrincipal() returning null...");
        return null;
    }

    public PermissionCollection getPermissions (final ProtectionDomain domain)
        throws AuthException
    {
        //log.debug
        //    ("getPermissions() protectionDomain codesource is "+
        //     domain.getCodeSource());

        final Principal principal = extractsEffectivePrincipal(domain);

        final PermissionCollection permissions = new Permissions();

        if (principal == null) 
        {
            //log.debug
            //    ("getPermissions(pd) No permissions for a null principal, "+
            //     "returning empty permission set");
            return permissions;
        }

        //log.debug("getPermissions() principal '"+principal.getName()+"'");

        java.util.Iterator it = principal.getGrants().iterator();
        while (it.hasNext())
        {
            String grantName = (String)it.next();

            //log.debug("getPermissions() examining grant '"+grantName+"'");

            Grant g = (Grant)this.grantMap.get(grantName);

            if (g == null)
            {
                //log.warn
                //    ("Skipped reference to an inexistent grant '"+
                //     grantName+"'.");
                continue;
            }

            //log.debug
            //    ("getPermissions() grant codesource is "+g.getCodeSource());

            if (g.codeSourceImplies(domain.getCodeSource()))
            {
                //log.debug("getPermissions() returning grant's permissions");

                java.util.Enumeration en = g.getPermissions().elements();
                while (en.hasMoreElements())
                {
                    java.security.Permission p = 
                        (java.security.Permission)en.nextElement();
                    permissions.add(p);

                    //log.debug("getPermissions() added permission "+p);
                }
            }
        }

        return permissions;
    }

    public PermissionCollection getPermissions (Subject s)
        throws AuthException
    {
        java.util.Set principals = s.getPrincipals(Principal.class);

        if (principals.size() < 1) return new Permissions();

        openwfe.org.auth.Principal principal = 
            (openwfe.org.auth.Principal)principals.iterator().next();

        PermissionCollection permissions = new Permissions();

        java.util.Iterator it = principal.getGrants().iterator();
        while (it.hasNext())
        {
            String grantName = (String)it.next();

            //log.debug("Examining grant '"+grantName+"'");

            Grant g = (Grant)this.grantMap.get(grantName);

            if (g == null)
            {
                //log.warn
                //    ("Skipped reference to an inexistent grant '"+
                //     grantName+"'.");
                continue;
            }

            final java.util.Enumeration en = g.getPermissions().elements();
            while (en.hasMoreElements())
            {
                java.security.Permission p = 
                    (java.security.Permission)en.nextElement();
                permissions.add(p);

                //log.debug("Added permission "+p);
            }
        }

        return permissions;
    }

    //
    // UMAN (user management) METHODS

    public java.util.List getPrincipals ()
    {
        return this.principalList;
    }

    public java.util.Map getGrants ()
    {
        return this.grantMap;
    }

    public synchronized void updatePrincipals (final java.util.List principals)
    {
        this.principalList = principals;

        buildPrincipalMap();
    }

    protected void buildPrincipalMap ()
    {
        this.principalMap = new java.util.HashMap();

        final java.util.Iterator it = this.principalList.iterator();
        while (it.hasNext())
        {
            final Principal p = (Principal)it.next();
            this.principalMap.put(p.getName(), p);
        }
    }

    public void updateGrants (final java.util.Map grants)
    {
        this.grantMap = grants;
    }

}
