/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: MethodJournal.java 2713 2006-06-01 14:38:45Z jmettraux $
 */

//
// MethodJournal.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.misc;

import openwfe.org.ReflectionUtils;


/**
 * An instance of this class stores a journal of operation to be performed
 * at a later point, it borrows the idea of journal of journalled filesystems.
 * It will be useful for implementing pausing a component : operations called
 * for a paused component will be stored here and then processed when the
 * 'play' is hit.
 * <br><br>
 * <i>idea for next iteration : It could be used in conjunction with a 
 * proxy...</i>
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: MethodJournal.java 2713 2006-06-01 14:38:45Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class MethodJournal
{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(MethodJournal.class.getName());

    //
    // CONSTANTS & co

    //
    // FIELDS

    private Object target = null;
    private java.util.List journal = new java.util.ArrayList(100);

    //
    // CONSTRUCTORS

    /**
     * Creates a new, empty MethodJournal instance for a given target
     * object.
     */
    public MethodJournal (final Object target)
    {
        this.target = target;
    }

    //
    // METHODS

    /**
     * Adds an operation to the journal, the operation will only be
     * executed when the flush method is called.
     */
    public void addOperation 
        (final String methodName, 
         final Class[] paramTypes, 
         final Object[] params)
    {
        synchronized (this.journal)
        {
            this.journal.add(new Entry(methodName, paramTypes, params));
        }
    }

    /**
     * Tells the journal to flush, ie executing all the stored operations
     * on its target.
     */
    public void flush ()
    {
        final long start = System.currentTimeMillis();

        synchronized (this.journal)
        {
            final java.util.Iterator it = this.journal.iterator();
            while (it.hasNext())
            {
                final Entry e = (Entry)it.next();
                try
                {
                    e.execute(this.target);
                }
                catch (final Exception ex)
                {
                    log.warn("flush() method call '"+e+"' failed", ex);
                }
            }
            this.journal.clear();
        }

        if (log.isDebugEnabled())
        {
            log.debug
                ("flush() took "+(System.currentTimeMillis() - start)+" ms");
        }
    }

    /**
     * Launches the flushing of journallised methods in a dedicated thread
     */
    public void flushInOwnThread ()
    {
        (new Thread()
         {
             public void run ()
             {
                 MethodJournal.this.flush();
             }
         }).start();
    }

    //
    // STATIC METHODS

    //
    // INNER CLASSES

    private static class Entry
    {
        private String methodName = null;
        private Class[] paramTypes = null;
        private Object[] params = null;

        public Entry 
            (final String methodName, 
             final Class[] paramTypes,
             final Object[] params)
        {
            this.methodName = methodName;
            this.paramTypes = paramTypes;
            this.params = params;
        }

        /*
        public String getMethodName () { return this.methodName; }
        public Object[] getParams () { return this.params; }
        */

        public void execute (final Object target)
            throws Exception
        {
            ReflectionUtils.invoke
                (target,
                 this.methodName,
                 this.paramTypes,
                 this.params);
        }

        public String toString ()
        {
            return this.methodName;
        }
    }

}
