/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: UniqueIdGenerator.java 2713 2006-06-01 14:38:45Z jmettraux $
 */

//
// UniqueIdGenerator.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.00 16.08.2003 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.misc;

/**
 * A generator that you instantiate and then use as a utility instance.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: UniqueIdGenerator.java 2713 2006-06-01 14:38:45Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class UniqueIdGenerator
{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(UniqueIdGenerator.class.getName());
    */

    //
    // CONSTANTS & co

    public final static String P_ID_PREFIX
        = "idPrefix";

    protected static long lastGivenId = 0;

    //
    // FIELDS

    protected int iPrefix = -1;
    protected String sPrefix = null;

    //
    // CONSTRUCTORS

    /**
     * Instantiates a basic id generator : one that returns Long instances
     * as ids
     */
    public UniqueIdGenerator ()
    {
        super();
    }

    /**
     * the String prefix will always be prepended to the long ids
     * generated, so you'll end up with a String uniqueId
     */
    public UniqueIdGenerator (final String sPrefix)
    {
        super();

        this.sPrefix = sPrefix;
    }

    /**
     * Instantiates a unique id generator that prefixes all its produced
     * ids with the given iPrefix, which must be comprised between 10 and 99.
     */
    public UniqueIdGenerator (final int iPrefix)
    {
        super();

        if (iPrefix < 10 || iPrefix > 99)
        {
            throw new RuntimeException
                ("iPrefix must be comprised between 10 and 99 included");
        }

        this.iPrefix = iPrefix;
    }

    //
    // METHODS

    /**
     * generates a unique id and prepares for generating the next one
     */
    public synchronized Object generateUniqueId ()
    {
        long id = System.currentTimeMillis();

        if (id <= lastGivenId)
        {
            id = lastGivenId+1;
        }
        lastGivenId = id;

        if (this.sPrefix != null) 
            return this.sPrefix + id;

        if (this.iPrefix > 9)
            return new Long(""+this.iPrefix+""+id);

        return new Long(id);
            // not returning directly lastGivenId...
    }

    /**
     * A shortcut for
     * <pre>
     * return ((Long)generateUniqueId).longValue();
     * </pre>
     * If you instantiated the generator with a String prefix,
     * calling this method will throw a ClassCastException.
     */
    public long generateUniqueLongId ()
    {
        return ((Long)generateUniqueId()).longValue();
    }

}
