/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: Time.java 2713 2006-06-01 14:38:45Z jmettraux $
 */

//
// Time.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.00 16.08.2003 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.time;

import java.text.SimpleDateFormat;


/**
 * A utility class : some methods for playing with time
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: Time.java 2713 2006-06-01 14:38:45Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class Time
{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(Time.class.getName());
    */

    /**
     * This method turns strings like '10h10m1s' into milliseconds.
     * If a number is given without end char, it is considered to be in
     * milliseconds directly.
     * This method understands :
     * <ul>
     *     <li>'w' weeks</li>
     *     <li>'d' days</li>
     *     <li>'h' hours</li>
     *     <li>'m' minutes</li>
     *     <li>'s' seconds</li>
     *     <li>'M' month</li>
     *     <li>'y' year</li>
     * </ul>
     */
    public static long parseTimeString (String time)
    {
        time = time.trim();

        int index = -1;
        long result = 0;

        String number = "";

        while (true)
        {
            index++;

            if (index >= time.length())
            {
                if (number.length() > 0)
                    result += Integer.parseInt(number);

                break;
            }

            char c = time.charAt(index);

            if (java.lang.Character.isDigit(c))
            {
                number += c;
                continue;
            }

            long value = Long.parseLong(number);
            number = "";

            if (c == 'y') // year
            {
                result += (value * 365 * 24 * 3600 * 1000);
            }
            else if (c == 'M') // month
            {
                result += (value * 30 * 24 * 3600 * 1000);
            }
            else if (c == 'w') // week
            {
                result += (value * 7 * 24 * 3600 * 1000);
            }
            else if (c == 'd') // day
            {
                result += (value * 24 * 3600 * 1000);
            }
            else if (c == 'h') // hour
            {
                result += (value * 3600 * 1000);
            }
            else if (c == 'm') // minute
            {
                result += (value * 60 * 1000);
            }
            else if (c == 's') // second
            {
                result += (value * 1000);
            }
            /*
             * some code from 'dgsh' :-)
             * (this method is copy-pasted 
             * from dgsh (http://sf.net/projects/dgsh))
             *
            else if (c == 'r') // round
            {
                result += (value * 6 * 1000);
            }
             *
             */
            else 
                // time is expressed in milliseconds
            {
                result += value;
            }
        }

        return result;
    }

    private static long[] tts 
        (final long time, final int divisor)
    {
        final long l0 = time % divisor;
        final long l1 = (time - l0) / divisor;

        return new long[] { l0, l1 };
    }

    /**
     * Given a time in milliseconds, return its duration in a human readable
     * String : 36000 -&gt; 36s.
     */
    public static String toTimeString 
        (final Long time, final boolean showMillis)
    {
        if (time == null) return "0ms";

        return toTimeString(time.longValue(), showMillis);
    }

    /**
     * Given a time in milliseconds, return its duration in a human readable
     * String : 36000 -&gt; 36s.
     */
    public static String toTimeString 
        (final long time, final boolean showMillis)
    {
        long[] ll = tts(time, 1000);

        final long ms = ll[0];

        ll = tts(ll[1], 60);

        final long s = ll[0];

        ll = tts(ll[1], 60);

        final long m = ll[0];

        ll = tts(ll[1], 24);

        final long h = ll[0];

        ll = tts(ll[1], 30);

        final long d = ll[0];

        ll = tts(ll[1], 12);

        final long M = ll[0];
        final long y = ll[1];

        //final long rem = ll[1];

        //
        // output

        final StringBuffer sb = new StringBuffer();

        if (y > 0)
            sb.append(y).append("y");
        if (M > 0)
            sb.append(M).append("M");
        if (d > 0)
            sb.append(d).append("d");
        if (h > 0)
            sb.append(h).append("h");
        if (m > 0)
            sb.append(m).append("m");
        if (s > 0)
            sb.append(s).append("s");

        if (showMillis)
            sb.append(ms).append("ms");

        //sb.append(" (").append(rem).append(" rem)");

        return sb.toString();
    }

    //
    // ISO DATE stuff

    /**
     * The SimpleDateFormat object for parsing / formatting date
     * from / to the ISO format.
     */
    public final static SimpleDateFormat SDF_ISO_DATE =
        new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");

    /**
     * The SimpleDateFormat object for parsing / formatting date
     * from / to the ISO format (short version, just date, no time).
     */
    public final static SimpleDateFormat SDF_ISO_DATE_SHORT =
        new SimpleDateFormat("yyyy-MM-dd");

    /*
     * parsing any date...
     */
    private static SimpleDateFormat[] dateFormats = new SimpleDateFormat[] 
    {
        SDF_ISO_DATE,
        SDF_ISO_DATE_SHORT,
        new SimpleDateFormat("yy-MM-dd HH:mm:ss"),
        new SimpleDateFormat("dd-MM-yy"),
        new SimpleDateFormat("dd-MM-yy HH:mm:ss")

            // for parsing, having just 'yy' is ok for 'yyyy' input too
    };

    /**
     * Tries to parse any date[time] format into a date.
     */
    public static java.util.Date parseDate (final String s)
    {
        if (s == null) return null;

        String sDate = s.trim();

        sDate = sDate.replace('/', '-');
        sDate = sDate.replace('.', '-');

        //log.debug("parseDate() in >"+sDate+"<");

        for (int i=0; i<dateFormats.length; i++)
        {
            try
            {
                final java.util.Date d = dateFormats[i].parse(sDate);

                //log.debug("parseDate() caught by sdf #"+i);

                return d;
            }
            catch (final Throwable t)
            {
                // ignore
            }
        }

        return null;
    }

    /**
     * Turns a time expressed as a long to a ISO (postgres) date format
     * like '1997-12-17 07:37:16-0800'.
     */
    public static String toIsoDate (final long time)
    {
        final java.util.Date d = new java.util.Date(time);
        return SDF_ISO_DATE.format(d);
    }

    /**
     * Turns a java.util.Date instance into a ISO (postgres) date format
     * like '1997-12-17 07:37:16-0800'.
     */
    public static String toIsoDate (final java.util.Date d)
    {
        return SDF_ISO_DATE.format(d);
    }

    /**
     * Turns the current time to a ISO (postgres) date format
     * like '1997-12-17 07:37:16-0800'.
     */
    public static String toIsoDate ()
    {
        return toIsoDate(System.currentTimeMillis());
    }

    /**
     * Turns the ISO date into date as a long value (number of millisecs
     * sine the Epoch).
     */
    public static long fromIsoDate (final String sDate)
        throws java.text.ParseException
    {
        return SDF_ISO_DATE.parse(sDate).getTime();
    }

    //
    // just testing...

    /*
    public static void main (final String[] args)
        throws Exception
    {
        //System.out.println(toTimeString(System.currentTimeMillis()));
        System.out.println(toTimeString(1000 * 36, false));
        System.out.println();
        System.out.println(""+parseTimeString("7d"));
        System.out.println();
        System.out.println(toTimeString(604800000L, true));
        System.out.println(toTimeString(604800000L, false));
    }
    */

}
