/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import openwfe.org.MapUtils;
import openwfe.org.OwfeRunnable;
import openwfe.org.Service;
import openwfe.org.ServiceException;
import openwfe.org.SharedApplicationContext;
import openwfe.org.state.PausedState;
import openwfe.org.state.RunningState;
import openwfe.org.state.ServiceState;
import openwfe.org.state.StoppedState;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

public class ApplicationContext
implements OwfeRunnable {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$ApplicationContext == null ? (class$openwfe$org$ApplicationContext = ApplicationContext.class$("openwfe.org.ApplicationContext")) : class$openwfe$org$ApplicationContext).getName());
    protected static final String SHARED = "shared";
    public static final String P_SERVICE_ITERATOR = "serviceIterator";
    public static final String P_APPLICATION_DIRECTORY = "applicationDirectory";
    public static final String K_LAST_MODIFIED = "__last_modified__";
    public static final Map contextMap = new HashMap();
    private ApplicationContext parentContext = null;
    private String applicationName = null;
    private Map map = new HashMap();
    private Map serviceIterators = new HashMap();
    private ServiceState contextState = new RunningState();
    static /* synthetic */ Class class$openwfe$org$ApplicationContext;

    public long getLastModified() {
        Long l = (Long)this.map.get(K_LAST_MODIFIED);
        if (l == null) {
            return -1L;
        }
        return l;
    }

    public void setLastModified(long l) {
        this.map.put(K_LAST_MODIFIED, new Long(l));
    }

    public void setApplicationName(String string) {
        this.applicationName = string;
    }

    public Map asMap() {
        return this.map;
    }

    public Object remove(String string) {
        return this.map.remove(string);
    }

    public void put(String string, Object object) {
        this.map.put(string, object);
    }

    public void add(Service service) {
        this.put(service.getName(), service);
    }

    public void putAll(Map map) {
        this.map.putAll(map);
    }

    public Object get(String string) {
        return this.lookup(string);
    }

    protected ApplicationContext getRootContext() {
        if (this.parentContext == null) {
            return this;
        }
        return this.parentContext.getRootContext();
    }

    public Object lookup(String string) {
        ApplicationContext applicationContext;
        if (string == null) {
            return null;
        }
        int n = string.indexOf("/");
        if (n < 0) {
            return this.map.get(string);
        }
        if (string.startsWith("./")) {
            return this.lookup(string.substring(2));
        }
        if (string.startsWith("../")) {
            return this.getParentContext().lookup(string.substring(3));
        }
        if (string.startsWith("/")) {
            return this.getRootContext().lookup(string.substring(1));
        }
        String string2 = string.substring(0, n);
        if (log.isDebugEnabled()) {
            log.debug((Object)("lookup() subContextName is '" + string2 + "'"));
        }
        if ((applicationContext = (ApplicationContext)this.map.get(string2)) == null) {
            return null;
        }
        return applicationContext.lookup(string.substring(n + 1));
    }

    public long getTime(String string) throws NumberFormatException {
        return MapUtils.getAsTime(this.map, string);
    }

    public long getLong(String string) throws NumberFormatException {
        return MapUtils.getAsLong(this.map, string);
    }

    public long getLong(String string, long l) {
        return MapUtils.getAsLong(this.map, string, l);
    }

    public int getInt(String string, int n) {
        return MapUtils.getAsInt(this.map, string, n);
    }

    public boolean getBoolean(String string, boolean bl) {
        return MapUtils.getAsBoolean(this.map, string, bl);
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public List itemsOfClass(Class clazz) {
        ArrayList arrayList = new ArrayList(this.map.size());
        Iterator iterator = this.map.values().iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            if (!clazz.isAssignableFrom(v.getClass())) continue;
            arrayList.add(v);
        }
        return arrayList;
    }

    public String getApplicationDirectory() {
        String string = (String)this.map.get(P_APPLICATION_DIRECTORY);
        if (string == null) {
            string = "./";
            this.map.put(P_APPLICATION_DIRECTORY, string);
        } else if (!string.endsWith(File.separator)) {
            string = string + File.separator;
            this.map.put(P_APPLICATION_DIRECTORY, string);
        }
        return string;
    }

    public void setApplicationDirectory(String string) {
        this.map.put(P_APPLICATION_DIRECTORY, string);
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getName() {
        return this.applicationName;
    }

    public Iterator serviceIterator() {
        ArrayList arrayList = new ArrayList(this.map.size());
        Iterator iterator = this.map.values().iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            if (!(v instanceof Service)) continue;
            arrayList.add(v);
        }
        return arrayList.iterator();
    }

    public ApplicationContext getParentContext() {
        return this.parentContext;
    }

    public void setParentContext(ApplicationContext applicationContext) {
        this.parentContext = applicationContext;
    }

    public void outputStatus(Element element) {
        Element element2;
        Object object;
        Service service;
        Iterator iterator = this.serviceIterator();
        while (iterator.hasNext()) {
            service = (Service)iterator.next();
            object = service.getStatus();
            if (object == null) {
                object = new Element("service");
                object.setAttribute("name", service.getName());
                element2 = new Element("null-status");
                object.addContent((Content)element2);
            }
            element.addContent((Content)object);
        }
        iterator = this.map.values().iterator();
        while (iterator.hasNext()) {
            service = iterator.next();
            if (!(service instanceof ApplicationContext)) continue;
            object = (ApplicationContext)((Object)service);
            element2 = new Element(((ApplicationContext)object).getApplicationName());
            ((ApplicationContext)object).outputStatus(element2);
            element.addContent((Content)element2);
        }
        service = new Element("free-memory");
        service.addContent("" + (double)Runtime.getRuntime().freeMemory() / 1000000.0 + " MB");
        object = new Element("max-memory");
        object.addContent("" + (double)Runtime.getRuntime().maxMemory() / 1000000.0 + " MB");
        element.addContent((Content)service);
        element.addContent((Content)object);
    }

    public void stop() throws ServiceException {
        this.setState(new StoppedState());
        Iterator iterator = this.map.values().iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            if (!(v instanceof OwfeRunnable)) continue;
            OwfeRunnable owfeRunnable = (OwfeRunnable)v;
            try {
                owfeRunnable.stop();
            }
            catch (ServiceException serviceException) {
                log.info((Object)("stop() had trouble when stopping '" + owfeRunnable.getName() + "'"), (Throwable)serviceException);
            }
        }
        log.info((Object)("stop() context '" + this.applicationName + "' stopped."));
    }

    public void play() throws ServiceException {
        log.info((Object)("play() requested for service '" + this.getName() + "'"));
        if (this.isRunning()) {
            return;
        }
        this.setState(new RunningState());
        Iterator iterator = this.map.values().iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            if (!(v instanceof OwfeRunnable)) continue;
            OwfeRunnable owfeRunnable = (OwfeRunnable)v;
            try {
                owfeRunnable.play();
            }
            catch (ServiceException serviceException) {
                log.info((Object)("play() had trouble when playing '" + owfeRunnable.getName() + "'"), (Throwable)serviceException);
            }
        }
    }

    public void pause() throws ServiceException {
        log.info((Object)("pause() requested for service '" + this.getName() + "'"));
        if (!this.isRunning()) {
            return;
        }
        this.setState(new PausedState());
        Iterator iterator = this.map.values().iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            if (!(v instanceof OwfeRunnable)) continue;
            OwfeRunnable owfeRunnable = (OwfeRunnable)v;
            try {
                owfeRunnable.pause();
            }
            catch (ServiceException serviceException) {
                log.info((Object)("pause() had trouble when pausing '" + owfeRunnable.getName() + "'"), (Throwable)serviceException);
            }
        }
    }

    public void update() throws ServiceException {
        log.info((Object)("update() requested for service '" + this.getName() + "'"));
        Iterator iterator = this.map.values().iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            if (!(v instanceof OwfeRunnable)) continue;
            OwfeRunnable owfeRunnable = (OwfeRunnable)v;
            try {
                owfeRunnable.update();
            }
            catch (ServiceException serviceException) {
                log.info((Object)("pause() had trouble when 'updating' '" + owfeRunnable.getName() + "'"), (Throwable)serviceException);
            }
        }
    }

    public ServiceState getState() {
        return this.contextState;
    }

    protected void setState(ServiceState serviceState) {
        this.contextState = serviceState;
    }

    public boolean isRunning() {
        return this.getState() instanceof RunningState;
    }

    public static ApplicationContext lookupContext(String string) {
        return (ApplicationContext)contextMap.get(string);
    }

    public static SharedApplicationContext lookupSharedContext() {
        return (SharedApplicationContext)contextMap.get(SHARED);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        SharedApplicationContext sharedApplicationContext = new SharedApplicationContext();
        contextMap.put(SHARED, sharedApplicationContext);
    }
}

