/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import openwfe.org.misc.ByteUtils;
import org.apache.log4j.Logger;

public abstract class Utils {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$Utils == null ? (class$openwfe$org$Utils = Utils.class$("openwfe.org.Utils")) : class$openwfe$org$Utils).getName());
    static /* synthetic */ Class class$openwfe$org$Utils;

    public static byte[] serialize(Serializable serializable) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(serializable);
        objectOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public static void copy(File file, String string) {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(string);
            byte[] byArray = new byte[1024];
            while ((n = fileInputStream.read(byArray)) >= 1) {
                fileOutputStream.write(byArray, 0, n);
                if (n >= 1024) continue;
                break;
            }
        }
        catch (IOException iOException) {
            try {
                fileInputStream.close();
                fileOutputStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.warn((Object)("copy() Failed to copy " + file.getPath() + " to " + string), (Throwable)iOException);
        }
    }

    public static void copy(String string, String string2) {
        Utils.copy(new File(string), string2);
    }

    public static void move(File file, String string) {
        Utils.copy(file, string);
        boolean bl = file.delete();
        if (!bl) {
            log.warn((Object)("move() failed to delete file '" + file.getPath() + "' after move."));
        }
    }

    public static void move(String string, String string2) {
        Utils.move(new File(string), string2);
    }

    public static String getMd5Digest(byte[] byArray) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            log.warn((Object)"cannot compute MD5 digest", (Throwable)noSuchAlgorithmException);
            return null;
        }
        messageDigest.update(byArray);
        return ByteUtils.toString(messageDigest.digest());
    }

    public static String getFileProtocolPrefix() {
        if (File.separatorChar == '\\') {
            return "file:/";
        }
        return "file:";
    }

    public static String removeFileProtocolPrefix(String string) {
        String string2 = string.substring(5);
        if (Utils.getFileProtocolPrefix().length() == 6 && string.startsWith(Utils.getFileProtocolPrefix())) {
            string2 = string.substring(6);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeFileProtocolPrefix() returning '" + string2 + "'"));
        }
        return string2;
    }

    public static String getCanonicalPath(String string, String string2) {
        File file = new File(string2);
        if (!file.isAbsolute()) {
            file = new File(string + string2);
        }
        try {
            String string3 = file.getCanonicalPath();
            if (log.isDebugEnabled()) {
                log.debug((Object)("getCanonicalPath() returning " + string3));
            }
            return string3;
        }
        catch (IOException iOException) {
            log.warn((Object)"getCanonicalPath() exception", (Throwable)iOException);
            return file.getAbsolutePath();
        }
    }

    public static boolean isUrl(String string) {
        try {
            new URL(string);
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    public static String expandUrl(String string) {
        return Utils.expandUrl(null, string);
    }

    public static String expandUrl(String string, String string2) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("expandUrl() considering >" + string2 + "<"));
        }
        if (string2.startsWith("field:")) {
            return string2;
        }
        if (string2.startsWith("resource:")) {
            return string2;
        }
        if (string2.startsWith("file:")) {
            String string3 = Utils.expandFileName(string, Utils.removeFileProtocolPrefix(string2));
            String string4 = Utils.getFileProtocolPrefix() + string3;
            if (log.isDebugEnabled()) {
                log.debug((Object)("expandUrl() 0 returning >" + string4 + "<"));
            }
            return string4;
        }
        if (!Utils.isUrl(string2)) {
            return Utils.expandUrl(string, Utils.getFileProtocolPrefix() + string2);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("expandUrl() 1 returning >" + string2 + "<"));
        }
        return string2;
    }

    public static String expandFileName(String string, String string2) {
        String string3 = null;
        String string4 = "";
        if (string != null) {
            string4 = string.trim() + File.separator;
        }
        string3 = File.separatorChar == '\\' ? (string2.charAt(1) == ':' ? string2 : string4 + string2) : (string2.charAt(0) == File.separatorChar ? string2 : string4 + string2);
        try {
            string3 = string3.endsWith("*") ? new File(string3.substring(0, string3.length() - 1)).getCanonicalPath() + File.separatorChar + "*" : new File(string3).getCanonicalPath();
        }
        catch (IOException iOException) {
            log.warn((Object)"expandFileName() failed to get canonical path", (Throwable)iOException);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("expandFileName() returning >" + string3 + "<"));
        }
        return string3;
    }

    public static String ensureProtocol(String string) {
        int n = (string = string.trim()).indexOf(":");
        if (n < 0 || n == 1) {
            return Utils.getFileProtocolPrefix() + string;
        }
        return string;
    }

    public static Set buildFileSet(String string) {
        HashSet hashSet = new HashSet();
        Utils.buildFileSet(hashSet, new File(string));
        return hashSet;
    }

    private static void buildFileSet(Set set, File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                Utils.buildFileSet(set, file2);
                continue;
            }
            set.add(file2.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean replace(List list, Object object, Object object2) {
        List list2 = list;
        synchronized (list2) {
            int n = -1;
            for (int i = 0; i < list.size(); ++i) {
                Object e = list.get(i);
                if (!e.equals(object)) continue;
                n = i;
                break;
            }
            if (n > -1) {
                list.remove(n);
                list.add(n, object2);
                return true;
            }
            return false;
        }
    }

    public static String changeToWebPath(String string, String string2, String string3) {
        string3 = string3.substring(string.length());
        string3 = string3.replace('\\', '/');
        if (!string2.endsWith("/") && !string3.startsWith("/")) {
            string2 = string2 + "/";
        }
        return string2 + string3;
    }

    public static void inc(Map map, String string) {
        Utils.inc(map, string, 1);
    }

    public static void inc(Map map, String string, int n) {
        Integer n2 = (Integer)map.get(string);
        if (n2 == null) {
            n2 = new Integer(0);
        }
        n2 = new Integer(n2 + n);
        map.put(string, n2);
    }

    public static int compareValues(Object object, Object object2) {
        try {
            double d = Double.parseDouble(object.toString());
            double d2 = Double.parseDouble(object2.toString());
            return (int)(d - d2);
        }
        catch (NumberFormatException numberFormatException) {
            return object.toString().compareTo(object2.toString());
        }
    }

    public static boolean toBoolean(Object object) {
        if (object == null) {
            return false;
        }
        String string = object.toString().trim();
        return "yes".equalsIgnoreCase(string) || "ok".equalsIgnoreCase(string) || "true".equalsIgnoreCase(string);
    }

    public static String getEncoding() {
        return System.getProperty("openwfe.xml.encoding", "ISO-8859-1");
    }

    public static Charset getCharset() {
        return Charset.forName(Utils.getEncoding());
    }

    public static String copyString(String string) {
        if (string == null) {
            return null;
        }
        return new String(string);
    }

    public static boolean stringEquals(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    public static void printStackTrace(Throwable throwable, Writer writer) {
        PrintWriter printWriter = new PrintWriter(writer);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
    }

    public static String stackTraceToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        return stringWriter.toString();
    }

    public static void debugMap(Logger logger, Map map) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n*** debugMap ***\n");
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object v = map.get(k);
            stringBuffer.append("   * ");
            stringBuffer.append(k);
            stringBuffer.append("   -->  ");
            stringBuffer.append(v);
            stringBuffer.append("\n");
        }
        logger.debug((Object)stringBuffer.toString());
    }

    public static String getTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String dump(String string, byte[] byArray) {
        try {
            File file = File.createTempFile(string, ".dmp");
            if (log.isDebugEnabled()) {
                log.debug((Object)("dump() to " + file.getPath()));
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
            fileOutputStream.close();
            return file.getPath();
        }
        catch (Throwable throwable) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("dump() failure " + throwable));
            }
            return null;
        }
    }

    public static String ensureForFileName(String string) {
        return string.replaceAll(" ", "_");
    }

    public static void logStackTrace(Logger logger, String string) {
        try {
            throw new Exception("openwfe.org.Utils.logStackTrace()");
        }
        catch (Exception exception) {
            logger.info((Object)string, (Throwable)exception);
            return;
        }
    }

    public static void logStackTrace(Logger logger) {
        Utils.logStackTrace(logger, "logStackTrace()");
    }

    public static Map copyHashMap(Map map) {
        if (map == null) {
            return null;
        }
        HashMap hashMap = new HashMap(map.size());
        hashMap.putAll(map);
        return hashMap;
    }

    public static Object getFirstElementOfClass(List list, Class clazz) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!clazz.isAssignableFrom(e.getClass())) continue;
            return e;
        }
        return null;
    }

    public static Object getLastElementOfClass(List list, Class clazz) {
        for (int i = list.size(); i > 0; --i) {
            Object e = list.get(i - 1);
            if (!clazz.isAssignableFrom(e.getClass())) continue;
            return e;
        }
        return null;
    }

    public static long getLastModified(String string) {
        try {
            return Utils.getLastModified(new URL(string));
        }
        catch (Throwable throwable) {
            log.info((Object)"getLastModified() failure", throwable);
            return -1L;
        }
    }

    public static long getLastModified(URL uRL) {
        try {
            return uRL.openConnection().getLastModified();
        }
        catch (Throwable throwable) {
            log.info((Object)"getLastModified() failure", throwable);
            return -1L;
        }
    }

    public static String[] toStringArray(List list) {
        if (list == null) {
            return null;
        }
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            stringArray[i] = list.get(i).toString();
        }
        return stringArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

