/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.auth;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import openwfe.org.auth.AuthException;
import openwfe.org.auth.LoginModule;
import openwfe.org.misc.ByteUtils;
import org.apache.log4j.Logger;

public class BasicLoginModule
extends LoginModule {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$auth$BasicLoginModule == null ? (class$openwfe$org$auth$BasicLoginModule = BasicLoginModule.class$("openwfe.org.auth.BasicLoginModule")) : class$openwfe$org$auth$BasicLoginModule).getName());
    public static final String DIGEST_ALGORITHM = "MD5";
    static /* synthetic */ Class class$openwfe$org$auth$BasicLoginModule;

    public static String digestPassword(String string) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(DIGEST_ALGORITHM);
        messageDigest.update(string.getBytes());
        return ByteUtils.toString(messageDigest.digest());
    }

    public boolean login() throws LoginException {
        if (this.policyService == null) {
            throw new LoginException("No policy service. Check application log for details");
        }
        NameCallback nameCallback = new NameCallback("username");
        PasswordCallback passwordCallback = new PasswordCallback("password", false);
        try {
            this.handler.handle(new Callback[]{nameCallback, passwordCallback});
        }
        catch (Exception exception) {
            log.debug((Object)"Failed to gather user credentials", (Throwable)exception);
            throw new LoginException("Failed to gather user credentials");
        }
        String string = nameCallback.getName();
        String string2 = new String(passwordCallback.getPassword());
        try {
            string2 = BasicLoginModule.digestPassword(string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            log.warn((Object)"hash algo not found", (Throwable)noSuchAlgorithmException);
            throw new LoginException("" + noSuchAlgorithmException);
        }
        this.principal = null;
        try {
            this.principal = this.policyService.authentify(string, string2);
        }
        catch (AuthException authException) {
            log.info((Object)"LoginException : Failed to authentify user", (Throwable)authException);
            throw new LoginException("Failed to authentify user because of \"" + authException + "\"");
        }
        this.succeeded = this.principal != null;
        return this.succeeded;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println();
            System.out.println("USAGE :");
            System.out.println();
            System.out.println("genpass password");
            System.out.println();
            System.out.print("will output the password, but hashed.");
            System.out.println();
            System.exit(0);
        }
        try {
            System.out.println(BasicLoginModule.digestPassword(stringArray[0]));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

