/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.auth;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import openwfe.org.Utils;
import openwfe.org.auth.AuthException;
import openwfe.org.misc.Text;
import org.apache.log4j.Logger;

public class Grant
implements Serializable {
    static final long serialVersionUID = -5673871754297625108L;
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$auth$Grant == null ? (class$openwfe$org$auth$Grant = Grant.class$("openwfe.org.auth.Grant")) : class$openwfe$org$auth$Grant).getName());
    public static final String NAME = "name";
    public static final String LOCATION = "location";
    public static final String CODE_SOURCE = "codeSource";
    protected String name = null;
    protected String url = null;
    protected CodeSource codeSource = null;
    protected Map permissionMap = null;
    static /* synthetic */ Class class$openwfe$org$auth$Grant;

    public Grant() {
        this.permissionMap = new HashMap(7);
    }

    public Grant(String string, String string2) throws MalformedURLException {
        this(string, string2, new HashSet(7));
    }

    public Grant(String string, String string2, Set set) throws MalformedURLException {
        this.name = string;
        this.url = string2;
        Certificate[] certificateArray = null;
        this.url = Text.substitute(this.url, System.getProperties());
        this.codeSource = new CodeSource(new URL(Utils.expandUrl(this.url)), certificateArray);
        this.permissionMap = new HashMap(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.addPermission((Permission)iterator.next());
        }
    }

    public void init(Map map) throws AuthException {
        this.name = (String)map.get(NAME);
        if (this.name == null) {
            throw new AuthException("Parameter 'name' is mandatory");
        }
        try {
            this.url = (String)map.get(CODE_SOURCE);
            if (this.url == null) {
                this.url = (String)map.get(LOCATION);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("init() url is >" + this.url + "<"));
            }
            Certificate[] certificateArray = null;
            this.codeSource = new CodeSource(new URL(Utils.expandUrl(this.url)), certificateArray);
        }
        catch (Exception exception) {
            throw new AuthException("Failed to determine 'codeSource'", exception);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getLocation() {
        return this.codeSource.getLocation().toString();
    }

    public boolean codeSourceImplies(CodeSource codeSource) {
        return this.codeSource.implies(codeSource);
    }

    public PermissionCollection getPermissions() {
        Permissions permissions = new Permissions();
        Iterator iterator = this.permissionMap.values().iterator();
        while (iterator.hasNext()) {
            Permission permission = (Permission)iterator.next();
            ((PermissionCollection)permissions).add(permission);
        }
        return permissions;
    }

    public Collection getPermissionValues() {
        return this.permissionMap.values();
    }

    public CodeSource getCodeSource() {
        return this.codeSource;
    }

    public void addPermission(Permission permission) {
        this.permissionMap.put(Grant.computeKey(permission), permission);
    }

    public void removePermission(String string) {
        Object v = this.permissionMap.remove(string);
    }

    public Permission getPermission(String string) {
        return (Permission)this.permissionMap.get(string);
    }

    public static String computeKey(Permission permission) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(permission.getClass().getName());
        stringBuffer.append("::");
        stringBuffer.append(permission.hashCode());
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

