/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.auth;

import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import openwfe.org.auth.AuthException;
import openwfe.org.auth.Grant;
import openwfe.org.auth.Principal;
import org.apache.log4j.Logger;

public class Passwd {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$auth$Passwd == null ? (class$openwfe$org$auth$Passwd = Passwd.class$("openwfe.org.auth.Passwd")) : class$openwfe$org$auth$Passwd).getName());
    private String name = null;
    private Map grantMap = null;
    private Map principalMap = null;
    private List principalList = null;
    static /* synthetic */ Class class$openwfe$org$auth$Passwd;
    static /* synthetic */ Class class$openwfe$org$auth$Principal;

    public Passwd(String string, List list, Map map) {
        this.name = string;
        this.principalList = list;
        this.grantMap = map;
        this.buildPrincipalMap();
    }

    public String getName() {
        return this.name;
    }

    public Map getPrincipalMap() {
        return this.principalMap;
    }

    public Map getGrantMap() {
        return this.grantMap;
    }

    public Principal authentify(String string, Object object) throws AuthException {
        Principal principal = (Principal)this.principalMap.get(string);
        if (principal == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No principal named '" + string + "' found in map"));
            }
            Iterator iterator = this.principalList.iterator();
            while (iterator.hasNext()) {
                Principal principal2 = (Principal)iterator.next();
                if (!string.matches(principal2.getName())) continue;
                principal = principal2;
                break;
            }
            if (principal == null) {
                throw new AuthException("No principal named '" + string + "' found");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("authentify() is p a copy ? " + principal.isCopy()));
        }
        if (!principal.authentify(object)) {
            log.debug((Object)"authentify() authentication failed.");
            return null;
        }
        return principal.getWorkCopy();
    }

    private Principal extractsEffectivePrincipal(ProtectionDomain protectionDomain) throws AuthException {
        java.security.Principal[] principalArray = protectionDomain.getPrincipals();
        for (int i = 0; i < principalArray.length; ++i) {
            Principal principal;
            Class<?> clazz;
            if (!(class$openwfe$org$auth$Principal == null ? Passwd.class$("openwfe.org.auth.Principal") : class$openwfe$org$auth$Principal).isAssignableFrom(clazz = (principal = (Principal)principalArray[i]).getClass())) continue;
            return principal;
        }
        return null;
    }

    public PermissionCollection getPermissions(ProtectionDomain protectionDomain) throws AuthException {
        Principal principal = this.extractsEffectivePrincipal(protectionDomain);
        Permissions permissions = new Permissions();
        if (principal == null) {
            return permissions;
        }
        Iterator iterator = principal.getGrants().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Grant grant = (Grant)this.grantMap.get(string);
            if (grant == null || !grant.codeSourceImplies(protectionDomain.getCodeSource())) continue;
            Enumeration<Permission> enumeration = grant.getPermissions().elements();
            while (enumeration.hasMoreElements()) {
                Permission permission = enumeration.nextElement();
                ((PermissionCollection)permissions).add(permission);
            }
        }
        return permissions;
    }

    public PermissionCollection getPermissions(Subject subject) throws AuthException {
        Set set = subject.getPrincipals(class$openwfe$org$auth$Principal == null ? (class$openwfe$org$auth$Principal = Passwd.class$("openwfe.org.auth.Principal")) : class$openwfe$org$auth$Principal);
        if (set.size() < 1) {
            return new Permissions();
        }
        Principal principal = (Principal)set.iterator().next();
        Permissions permissions = new Permissions();
        Iterator iterator = principal.getGrants().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Grant grant = (Grant)this.grantMap.get(string);
            if (grant == null) continue;
            Enumeration<Permission> enumeration = grant.getPermissions().elements();
            while (enumeration.hasMoreElements()) {
                Permission permission = enumeration.nextElement();
                ((PermissionCollection)permissions).add(permission);
            }
        }
        return permissions;
    }

    public List getPrincipals() {
        return this.principalList;
    }

    public Map getGrants() {
        return this.grantMap;
    }

    public synchronized void updatePrincipals(List list) {
        this.principalList = list;
        this.buildPrincipalMap();
    }

    protected void buildPrincipalMap() {
        this.principalMap = new HashMap();
        Iterator iterator = this.principalList.iterator();
        while (iterator.hasNext()) {
            Principal principal = (Principal)iterator.next();
            this.principalMap.put(principal.getName(), principal);
        }
    }

    public void updateGrants(Map map) {
        this.grantMap = map;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

