/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.auth;

import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.RunnableService;
import openwfe.org.ServiceException;
import openwfe.org.auth.AuthException;
import openwfe.org.auth.Passwd;
import openwfe.org.auth.PasswdCodec;
import openwfe.org.auth.Principal;
import openwfe.org.auth.UmanPermission;
import openwfe.org.state.PausedState;
import openwfe.org.state.RunningState;
import openwfe.org.state.ServiceState;
import openwfe.org.state.StoppedState;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class PolicyService
extends Policy
implements RunnableService {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$auth$PolicyService == null ? (class$openwfe$org$auth$PolicyService = PolicyService.class$("openwfe.org.auth.PolicyService")) : class$openwfe$org$auth$PolicyService).getName());
    public static final String POLICY_SERVICE = "policyService";
    public static final String P_PASSWD_CODEC = "passwdCodec";
    public static final String P_REFRESH_EACH_TIME = "refreshEachTime";
    private String serviceName = null;
    private ApplicationContext applicationContext = null;
    private Map serviceParams = null;
    private ServiceState serviceState = null;
    private Policy deferredPolicy = null;
    private PasswdCodec passwdCodec = null;
    private Passwd passwd = null;
    private boolean refreshEachTime = false;
    static /* synthetic */ Class class$openwfe$org$auth$PolicyService;
    static /* synthetic */ Class class$openwfe$org$auth$xml$XmlPasswdCodec;

    public void init(String string, ApplicationContext applicationContext, Map map) throws ServiceException {
        this.serviceName = string;
        this.applicationContext = applicationContext;
        this.serviceParams = map;
        String string2 = (String)this.serviceParams.get(P_PASSWD_CODEC);
        if (string2 == null) {
            string2 = (class$openwfe$org$auth$xml$XmlPasswdCodec == null ? (class$openwfe$org$auth$xml$XmlPasswdCodec = PolicyService.class$("openwfe.org.auth.xml.XmlPasswdCodec")) : class$openwfe$org$auth$xml$XmlPasswdCodec).getName();
            log.info((Object)"init() using default PasswdCodec");
        }
        log.info((Object)("init() using PasswdCodec '" + string2 + "'"));
        try {
            Class<?> clazz = Class.forName(string2);
            this.passwdCodec = (PasswdCodec)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new ServiceException("Failed to load codec, service '" + this.serviceName + "' cannot continue.", exception);
        }
        this.passwdCodec.init(this.applicationContext, this.serviceParams);
        this.refreshEachTime = MapUtils.getAsBoolean(map, P_REFRESH_EACH_TIME, false);
        log.info((Object)("init() refresh passwd each time ? " + this.refreshEachTime));
        this.deferredPolicy = Policy.getPolicy();
        this.loadPasswd();
        log.info((Object)"init() passwd successfully decoded");
        Policy.setPolicy(this);
        log.info((Object)"init() set self as system security Policy.");
    }

    protected void loadPasswd() throws ServiceException {
        try {
            this.passwd = this.passwdCodec.decodePasswd();
        }
        catch (AuthException authException) {
            throw new ServiceException("Failed to load Passwd", authException);
        }
    }

    public Principal authentify(String string, Object object) throws AuthException {
        if (this.refreshEachTime) {
            this.refresh();
        }
        return this.passwd.authentify(string, object);
    }

    public void play() throws ServiceException {
        log.info((Object)("play() requested for service '" + this.getName() + "'"));
        if (!this.isRunning()) {
            this.serviceState = new RunningState();
        }
    }

    public void pause() throws ServiceException {
        log.info((Object)("pause() requested for service '" + this.getName() + "'"));
        if (this.isRunning()) {
            this.serviceState = new PausedState();
        }
    }

    public void stop() throws ServiceException {
        log.info((Object)("stop() requested for service '" + this.getName() + "'"));
        this.serviceState = new StoppedState();
    }

    public void update() throws ServiceException {
        log.info((Object)("update() requested for service '" + this.getName() + "'"));
    }

    public ServiceState getState() {
        return this.serviceState;
    }

    protected void setState(ServiceState serviceState) {
        this.serviceState = serviceState;
    }

    public String getName() {
        return this.serviceName;
    }

    public ApplicationContext getContext() {
        return this.applicationContext;
    }

    public Map getParams() {
        return Collections.unmodifiableMap(this.serviceParams);
    }

    public Element getStatus() {
        return new Element(this.getName());
    }

    public boolean isRunning() {
        return this.getState() instanceof RunningState;
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection permissionCollection = this.deferredPolicy.getPermissions(codeSource);
        return permissionCollection;
    }

    public PermissionCollection getPermissions(ProtectionDomain protectionDomain) {
        PermissionCollection permissionCollection = this.deferredPolicy.getPermissions(protectionDomain);
        PermissionCollection permissionCollection2 = null;
        try {
            permissionCollection2 = this.passwd.getPermissions(protectionDomain);
        }
        catch (Exception exception) {
            permissionCollection2 = new Permissions();
        }
        Enumeration<Permission> enumeration = permissionCollection2.elements();
        while (enumeration.hasMoreElements()) {
            Permission permission = enumeration.nextElement();
            permissionCollection.add(permission);
        }
        return permissionCollection;
    }

    public PermissionCollection getPermissions(Subject subject) throws AuthException {
        return this.passwd.getPermissions(subject);
    }

    public void refresh() {
        log.info((Object)("refresh() '" + this.serviceName + "'"));
        try {
            this.loadPasswd();
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        this.deferredPolicy.refresh();
    }

    public List getPrincipals() {
        this.checkAccess();
        return this.passwd.getPrincipals();
    }

    public Map getGrants() {
        this.checkAccess();
        return this.passwd.getGrants();
    }

    public void updatePrincipals(List list) {
        this.checkAccess();
        this.passwd.updatePrincipals(list);
    }

    public void updateGrants(Map map) {
        this.checkAccess();
        this.passwd.updateGrants(map);
    }

    public void savePasswd() throws AuthException {
        this.checkAccess();
        this.passwdCodec.encodePasswd(this.passwd);
    }

    protected void checkAccess() {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("name", this.passwd.getName());
        AccessController.checkPermission(new UmanPermission(hashMap));
    }

    public static PolicyService lookupPolicyService(ApplicationContext applicationContext) {
        PolicyService policyService = (PolicyService)applicationContext.lookup(POLICY_SERVICE);
        if (policyService != null) {
            return policyService;
        }
        if (applicationContext.getParentContext() == null) {
            return null;
        }
        return PolicyService.lookupPolicyService(applicationContext.getParentContext());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

