/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.auth;

import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import openwfe.org.auth.Permission;
import openwfe.org.auth.ServicePermissionCollection;
import org.apache.log4j.Logger;

public class ServicePermission
extends Permission {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$auth$ServicePermission == null ? (class$openwfe$org$auth$ServicePermission = ServicePermission.class$("openwfe.org.auth.ServicePermission")) : class$openwfe$org$auth$ServicePermission).getName());
    public static final String ACTIONS = "actions";
    private List actionList = null;
    static /* synthetic */ Class class$openwfe$org$auth$ServicePermission;

    public ServicePermission(Map map) {
        super(map);
        this.buildActionList((String)map.get(ACTIONS));
    }

    private void buildActionList(String string) {
        String[] stringArray = string.split(", *");
        this.actionList = new ArrayList(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.actionList.add(stringArray[i].trim().toLowerCase());
        }
        Collections.sort(this.actionList);
    }

    private boolean isActionListEqual(ServicePermission servicePermission) {
        if (this.actionList.size() != servicePermission.actionList.size()) {
            return false;
        }
        Iterator iterator = this.actionList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (servicePermission.actionList.contains(string)) continue;
            return false;
        }
        return true;
    }

    private boolean isActionWildCard() {
        return this.actionList.size() == 1 && ((String)this.actionList.get(0)).equals("*");
    }

    private boolean actionImplies(ServicePermission servicePermission) {
        if (this.isActionWildCard()) {
            return true;
        }
        if (this.actionList.size() < servicePermission.actionList.size()) {
            return false;
        }
        Iterator iterator = servicePermission.actionList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.actionList.contains(string)) continue;
            return false;
        }
        return true;
    }

    public String actionListToString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.actionList.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public String getActions() {
        return this.actionListToString();
    }

    public int hashCode() {
        return this.getName().hashCode() + ((Object)this.actionList).hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ServicePermission)) {
            return false;
        }
        ServicePermission servicePermission = (ServicePermission)object;
        return this.getName().equals(servicePermission.getName()) && this.isActionListEqual(servicePermission);
    }

    public boolean implies(java.security.Permission permission) {
        if (permission == null || !(permission instanceof ServicePermission)) {
            return false;
        }
        ServicePermission servicePermission = (ServicePermission)permission;
        if (log.isDebugEnabled()) {
            log.debug((Object)("does " + this + " implies " + servicePermission + " ?"));
        }
        if (!this.getName().equals(servicePermission.getName()) && !this.getName().trim().equals("*")) {
            return false;
        }
        return this.actionImplies(servicePermission);
    }

    public PermissionCollection newPermissionCollection() {
        return new ServicePermissionCollection();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<ServicePermission name=\"");
        stringBuffer.append(this.getName());
        stringBuffer.append("\" actions=\"");
        stringBuffer.append(this.actionListToString());
        stringBuffer.append("\" />");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

