/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.auth.sql;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import openwfe.org.ApplicationContext;
import openwfe.org.ReflectionUtils;
import openwfe.org.ServiceException;
import openwfe.org.auth.AuthException;
import openwfe.org.auth.Grant;
import openwfe.org.auth.Passwd;
import openwfe.org.auth.PasswdCodec;
import openwfe.org.auth.Permission;
import openwfe.org.auth.Principal;
import openwfe.org.sql.SqlParameters;
import openwfe.org.sql.SqlUtils;
import openwfe.org.sql.ds.OwfeDataSource;
import org.apache.log4j.Logger;

public class SqlPasswdCodec
implements PasswdCodec {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$auth$sql$SqlPasswdCodec == null ? (class$openwfe$org$auth$sql$SqlPasswdCodec = SqlPasswdCodec.class$("openwfe.org.auth.sql.SqlPasswdCodec")) : class$openwfe$org$auth$sql$SqlPasswdCodec).getName());
    protected static final String T_GRANTED = "pgranted";
    protected static final String T_GRANT = "pgrant";
    protected static final String T_PARAMETER = "pparameter";
    protected static final String C_NAME = "name";
    protected static final String C_CODEBASE = "codebase";
    protected static final String C_USERNAME = "username";
    protected static final String C_GRANTNAME = "grantname";
    protected static final String G_PRINCIPAL = "principal";
    protected static final String G_PERMISSION = "permission";
    protected final SqlParameters sqlParams = new SqlParameters("pparameter", "pid", "pgroup", "pkey", "pval");
    private ApplicationContext context = null;
    private Map serviceParams = null;
    static /* synthetic */ Class class$openwfe$org$auth$sql$SqlPasswdCodec;

    public void init(ApplicationContext applicationContext, Map map) {
        this.context = applicationContext;
        this.serviceParams = map;
    }

    public void encodePasswd(Passwd passwd) throws AuthException {
        Serializable serializable;
        Iterator iterator;
        OwfeDataSource owfeDataSource = null;
        try {
            owfeDataSource = SqlUtils.lookupDataSource(this.context, this.serviceParams);
        }
        catch (ServiceException serviceException) {
            throw new AuthException("didn't find data source", serviceException);
        }
        Statement statement = null;
        try {
            statement = owfeDataSource.getConnection().createStatement();
            statement.execute("DELETE FROM pgranted");
            statement.execute("DELETE FROM pgrant");
            statement.execute("DELETE FROM pparameter");
        }
        catch (SQLException sQLException) {
            SqlUtils.closeStatement(statement);
            throw new AuthException("Failed to clean tables", sQLException);
        }
        try {
            iterator = passwd.getPrincipalMap().values().iterator();
            while (iterator.hasNext()) {
                serializable = (Principal)iterator.next();
                this.encodePrincipal(owfeDataSource.getConnection(), (Principal)serializable);
            }
        }
        catch (SQLException sQLException) {
            throw new AuthException("Failed to insert principal parameters", sQLException);
        }
        try {
            iterator = passwd.getGrantMap().values().iterator();
            while (iterator.hasNext()) {
                serializable = (Grant)iterator.next();
                this.encodeGrant(owfeDataSource.getConnection(), (Grant)serializable);
            }
        }
        catch (SQLException sQLException) {
            throw new AuthException("Failed to insert grants", sQLException);
        }
        owfeDataSource.releaseConnection();
    }

    public Passwd decodePasswd(Object object) throws AuthException {
        return this.decodePasswd(null);
    }

    public Passwd decodePasswd() throws AuthException {
        OwfeDataSource owfeDataSource = null;
        try {
            owfeDataSource = SqlUtils.lookupDataSource(this.context, this.serviceParams);
        }
        catch (ServiceException serviceException) {
            throw new AuthException("didn't find data source", serviceException);
        }
        try {
            Passwd passwd = new Passwd("passwd", this.decodePrincipals(owfeDataSource.getConnection()), this.decodeGrants(owfeDataSource.getConnection()));
            return passwd;
        }
        catch (Exception exception) {
            throw new AuthException("failed to load passwd info", exception);
        }
        finally {
            owfeDataSource.releaseConnection();
        }
    }

    protected List decodePrincipals(Connection connection) throws Exception {
        List list = this.sqlParams.extractParameters(connection, G_PRINCIPAL, C_NAME);
        ArrayList<Principal> arrayList = new ArrayList<Principal>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            Principal principal = (Principal)ReflectionUtils.initObject(map);
            arrayList.add(principal);
        }
        this.decodeGranted(connection, arrayList);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decodeGranted(Connection connection, List list) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        stringBuffer.append(C_USERNAME);
        stringBuffer.append(", ");
        stringBuffer.append(C_GRANTNAME);
        stringBuffer.append(" FROM ");
        stringBuffer.append(T_GRANTED);
        String string = stringBuffer.toString();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                Principal principal;
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("decodeGranted() looking for >" + string2 + "<"));
                }
                if ((principal = this.getPrincipal(list, string2)) == null) {
                    log.warn((Object)("decodeGranted() username >" + string2 + "< not found. Skipping grant."));
                    continue;
                }
                principal.addGrant(string3);
            }
        }
        catch (Throwable throwable) {
            SqlUtils.closeStatement(statement, resultSet);
            throw throwable;
        }
        SqlUtils.closeStatement(statement, resultSet);
    }

    protected Principal getPrincipal(List list, String string) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Principal principal = (Principal)iterator.next();
            if (!principal.getName().equals(string)) continue;
            return principal;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map decodeGrants(Connection connection) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        stringBuffer.append(C_NAME);
        stringBuffer.append(", ");
        stringBuffer.append(C_CODEBASE);
        stringBuffer.append(" FROM ");
        stringBuffer.append(T_GRANT);
        String string = stringBuffer.toString();
        HashMap<String, Grant> hashMap = new HashMap<String, Grant>();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                Grant grant = new Grant(string2, string3);
                hashMap.put(string2, grant);
            }
        }
        catch (Throwable throwable) {
            SqlUtils.closeStatement(statement, resultSet);
            throw throwable;
        }
        SqlUtils.closeStatement(statement, resultSet);
        this.decodePermissions(connection, hashMap);
        return hashMap;
    }

    protected void decodePermissions(Connection connection, Map map) throws Exception {
        List list = this.sqlParams.extractParameters(connection, G_PERMISSION, C_GRANTNAME);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Map map2 = (Map)iterator.next();
            String string = (String)map2.get("class");
            Class<?> clazz = Class.forName(string);
            Permission permission = (Permission)ReflectionUtils.buildInstance(clazz, map2);
            Grant grant = (Grant)map.get((String)map2.get(C_GRANTNAME));
            grant.addPermission(permission);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encodePrincipal(Connection connection, Principal principal) throws SQLException {
        long l = this.sqlParams.insertParams(connection, G_PRINCIPAL, principal.getInitParameters());
        Statement statement = null;
        try {
            Iterator iterator = principal.getGrants().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("INSERT INTO ");
                stringBuffer.append(T_GRANTED);
                stringBuffer.append(" (");
                stringBuffer.append(C_USERNAME);
                stringBuffer.append(", ");
                stringBuffer.append(C_GRANTNAME);
                stringBuffer.append(") VALUES (");
                stringBuffer.append(SqlUtils.prepareString(principal.getName()));
                stringBuffer.append(", ");
                stringBuffer.append(SqlUtils.prepareString(string));
                stringBuffer.append(")");
                String string2 = stringBuffer.toString();
                statement = connection.createStatement();
                statement.execute(string2);
            }
        }
        finally {
            SqlUtils.closeStatement(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encodeGrant(Connection connection, Grant grant) throws SQLException {
        Statement statement = null;
        try {
            String string = grant.getUrl();
            if (log.isDebugEnabled()) {
                log.debug((Object)("encodeGrant() codebase is >" + string + "<"));
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("INSERT INTO ");
            stringBuffer.append(T_GRANT);
            stringBuffer.append(" (");
            stringBuffer.append(C_NAME);
            stringBuffer.append(", ");
            stringBuffer.append(C_CODEBASE);
            stringBuffer.append(") VALUES (");
            stringBuffer.append(SqlUtils.prepareString(grant.getName()));
            stringBuffer.append(", ");
            stringBuffer.append(SqlUtils.prepareString(string));
            stringBuffer.append(")");
            String string2 = stringBuffer.toString();
            statement = connection.createStatement();
            statement.execute(string2);
            Enumeration<java.security.Permission> enumeration = grant.getPermissions().elements();
            while (enumeration.hasMoreElements()) {
                Permission permission = (Permission)enumeration.nextElement();
                HashMap<String, String> hashMap = new HashMap<String, String>(permission.getParameters().size());
                hashMap.put(C_GRANTNAME, grant.getName());
                hashMap.put("class", permission.getClass().getName());
                hashMap.putAll(permission.getParameters());
                this.sqlParams.insertParams(connection, G_PERMISSION, hashMap);
            }
        }
        catch (Throwable throwable) {
            SqlUtils.closeStatement(statement);
            throw throwable;
        }
        SqlUtils.closeStatement(statement);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

