/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.crypto;

import java.io.Serializable;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import openwfe.org.crypto.CryptoException;
import openwfe.org.crypto.RsaKey;
import openwfe.org.misc.ByteUtils;

public class SignedObject
implements Serializable {
    private Serializable object = null;
    private String signature = null;

    public SignedObject() {
    }

    public SignedObject(Serializable serializable, RsaKey rsaKey) throws CryptoException {
        this.object = serializable;
        try {
            Signature signature = Signature.getInstance("MD5withRSA");
            signature.initSign((PrivateKey)((Object)rsaKey.assembleRealKey()));
            signature.update(ByteUtils.objectToByteArray(this.object));
            this.signature = ByteUtils.toString(signature.sign());
        }
        catch (Exception exception) {
            throw new CryptoException("Failed to sign object", exception);
        }
    }

    public Serializable getObject() {
        return this.object;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setObject(Serializable serializable) {
        this.object = serializable;
    }

    public void setSignature(String string) {
        this.signature = string;
    }

    public boolean verify(RsaKey rsaKey) throws CryptoException {
        try {
            Signature signature = Signature.getInstance("MD5withRSA");
            signature.initVerify((PublicKey)((Object)rsaKey.assembleRealKey()));
            signature.update(ByteUtils.objectToByteArray(this.object));
            return signature.verify(ByteUtils.fromString(this.signature));
        }
        catch (Exception exception) {
            throw new CryptoException("Failed to verify signed object", exception);
        }
    }
}

