/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.misc;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import openwfe.org.xml.XmlUtils;
import org.jdom.Content;
import org.jdom.Element;

public class Cache {
    private int maxSize = -1;
    private LruMap cache = null;

    public Cache(int n) {
        this.maxSize = n;
        if (n < 1) {
            throw new IllegalArgumentException("Cannot build a cache with a maxSize < 1 : " + n);
        }
        this.cache = new LruMap(n);
    }

    public Cache() {
        this(100);
    }

    public synchronized Object get(Object object) {
        return this.cache.get(object);
    }

    public synchronized Object remove(Object object) {
        return this.cache.remove(object);
    }

    public synchronized void put(Object object, Object object2) {
        this.cache.put(object, object2);
    }

    public int size() {
        return this.cache.size();
    }

    public int maxSize() {
        return this.maxSize;
    }

    public Iterator iterator() {
        return this.cache.values().iterator();
    }

    public Set keySet() {
        return this.cache.keySet();
    }

    public Element getStatus() {
        Element element = new Element("cache");
        element.addContent((Content)XmlUtils.getRevisionElt("$Id: Cache.java 2713 2006-06-01 14:38:45Z jmettraux $"));
        Iterator iterator = this.cache.keySet().iterator();
        while (iterator.hasNext()) {
            Element element2 = new Element("key");
            element2.addContent(iterator.next().toString());
            element.addContent((Content)element2);
        }
        return element;
    }

    private static class LruMap
    extends LinkedHashMap {
        private int capacity = -1;

        public LruMap(int n) {
            super(n, 0.75f, true);
            this.capacity = n;
        }

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > this.capacity;
        }
    }
}

