/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.net;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import openwfe.org.Utils;
import openwfe.org.misc.IoUtils;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public abstract class NetUtils {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$net$NetUtils == null ? (class$openwfe$org$net$NetUtils = NetUtils.class$("openwfe.org.net.NetUtils")) : class$openwfe$org$net$NetUtils).getName());
    public static final String HTTP_EOL = "\r\n";
    public static final String DOUBLE_HTTP_EOL = "\r\n\r\n";
    private static SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.ENGLISH);
    static /* synthetic */ Class class$openwfe$org$net$NetUtils;

    public static byte[] channelToByteArray(ReadableByteChannel readableByteChannel) throws IOException {
        int n;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(16384);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        WritableByteChannel writableByteChannel = Channels.newChannel(byteArrayOutputStream);
        int n2 = 0;
        while ((n = readableByteChannel.read(byteBuffer)) >= 0) {
            if (n == 0) {
                if (++n2 >= 2) break;
                Thread.currentThread();
                Thread.yield();
                continue;
            }
            n2 = 0;
            byteBuffer.flip();
            writableByteChannel.write(byteBuffer);
            byteBuffer.clear();
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }

    public static InputStream channelToInputStream(ReadableByteChannel readableByteChannel) throws IOException {
        return new ByteArrayInputStream(NetUtils.channelToByteArray(readableByteChannel));
    }

    public static Reader channelToReader(ReadableByteChannel readableByteChannel) throws IOException {
        return new InputStreamReader(NetUtils.channelToInputStream(readableByteChannel));
    }

    public static byte[] readHttpRequest(ReadableByteChannel readableByteChannel) throws IOException {
        int n = 0;
        String string = null;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(16384);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        WritableByteChannel writableByteChannel = Channels.newChannel(byteArrayOutputStream);
        while (true) {
            int n2 = readableByteChannel.read(byteBuffer);
            if (log.isDebugEnabled()) {
                log.debug((Object)("readHttpRequest() read " + n2 + " bytes"));
            }
            if (n2 == 0) {
                if (++n > 3) break;
                Thread.currentThread();
                Thread.yield();
                continue;
            }
            byteBuffer.flip();
            writableByteChannel.write(byteBuffer);
            boolean bl = NetUtils.isEol(byteBuffer);
            String string2 = NetUtils.determineRequestType(byteBuffer);
            if (log.isDebugEnabled()) {
                log.debug((Object)("readHttpRequest() [ requestType is  " + string));
                log.debug((Object)("readHttpRequest()   reachedEol is   " + bl));
                log.debug((Object)("readHttpRequest()   curReqType is   " + string2 + " ]"));
            }
            if (string == null ? "GET".equals(string = string2) && bl : bl) break;
            n = 0;
            byteBuffer.clear();
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static String determineRequestType(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.rewind();
        if (byteBuffer.remaining() < 4) {
            return null;
        }
        byte[] byArray = new byte[4];
        for (int i = 0; i < 4; ++i) {
            byArray[i] = byteBuffer.get();
        }
        String string = new String(byArray, Utils.getEncoding());
        string = string.toLowerCase();
        if (log.isDebugEnabled()) {
            log.debug((Object)("determineRequestType() found >" + string + "<"));
        }
        if (string.equals("get ")) {
            return "GET";
        }
        if (string.equals("post")) {
            return "POST";
        }
        return null;
    }

    private static boolean isEol(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.rewind();
        if (byteBuffer.remaining() < 4) {
            return false;
        }
        byteBuffer.position(byteBuffer.limit() - 4);
        byte[] byArray = new byte[4];
        for (int i = 0; i < 4; ++i) {
            byArray[i] = byteBuffer.get();
        }
        String string = new String(byArray, Utils.getEncoding());
        return string.equals(DOUBLE_HTTP_EOL);
    }

    private static String asIntSequence(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            stringBuffer.append((int)c);
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void httpReply(SelectionKey selectionKey, int n, String string, String string2, String[] stringArray, String string3, Object object) {
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        PrintWriter printWriter = null;
        try {
            NetUtils.drainInput(selectionKey);
            byteArrayOutputStream = new ByteArrayOutputStream();
            printWriter = new PrintWriter(byteArrayOutputStream);
            printWriter.print("HTTP/1.0 " + n + " " + string);
            printWriter.print(HTTP_EOL);
            printWriter.print("Date: " + NetUtils.formatDate(new Date()));
            printWriter.print(HTTP_EOL);
            printWriter.print("Server: " + string2);
            printWriter.print(HTTP_EOL);
            printWriter.print("Content-type: " + string3);
            printWriter.print(HTTP_EOL);
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    printWriter.print(stringArray[i]);
                    printWriter.print(HTTP_EOL);
                }
            }
            printWriter.print(HTTP_EOL);
            if (object != null) {
                if (object instanceof Throwable) {
                    ((Throwable)object).printStackTrace(printWriter);
                } else if (object instanceof Element) {
                    Document document = new Document((Element)object);
                    XMLOutputter xMLOutputter = XmlUtils.getXMLOutputter();
                    printWriter.flush();
                    xMLOutputter.output(document, (OutputStream)byteArrayOutputStream);
                    byteArrayOutputStream.flush();
                } else {
                    log.debug((Object)"httpReply() body is something else");
                    printWriter.print(object.toString());
                }
            } else {
                printWriter.print("no comment.");
            }
            printWriter.print(HTTP_EOL);
            printWriter.print(HTTP_EOL);
            printWriter.print(HTTP_EOL);
            printWriter.print(HTTP_EOL);
            printWriter.flush();
            printWriter.close();
            ByteBuffer byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
            int n2 = byteBuffer.capacity();
            abstractInterruptibleChannel = (SocketChannel)selectionKey.channel();
            int n3 = 0;
            while ((n3 += ((SocketChannel)abstractInterruptibleChannel).write(byteBuffer)) < n2) {
            }
        }
        catch (Throwable throwable) {
            log.info((Object)"httpReply() Failed to reply to rest client", throwable);
        }
        finally {
            try {
                abstractInterruptibleChannel.close();
            }
            catch (Throwable throwable) {}
            try {
                selectionKey.cancel();
            }
            catch (Throwable throwable) {}
        }
    }

    public static String formatDate(Date date) {
        return sdf.format(date);
    }

    public static String keyStatus(SelectionKey selectionKey) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{ key valid:").append(selectionKey.isValid()).append(" readable:").append(selectionKey.isReadable()).append(" writable:").append(selectionKey.isWritable()).append(" channel:").append(selectionKey.channel()).append(" }");
        return stringBuffer.toString();
    }

    public static void drainInput(SelectionKey selectionKey) {
        ReadableByteChannel readableByteChannel = (ReadableByteChannel)((Object)selectionKey.channel());
        int n = 0;
        int n2 = 0;
        try {
            int n3;
            while ((n3 = IoUtils.read(readableByteChannel)) >= 0) {
                if (n3 == 0) {
                    if (n2 < 5) {
                        ++n2;
                        Thread.yield();
                        continue;
                    }
                    break;
                }
                ++n;
                n2 = 0;
            }
        }
        catch (Throwable throwable) {
            log.debug((Object)"drainInput() read failure", throwable);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("drainInput() found " + n + " bytes."));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

