/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Map;
import openwfe.org.AbstractService;
import openwfe.org.ApplicationContext;
import openwfe.org.MapUtils;
import openwfe.org.ServiceException;
import org.apache.log4j.Logger;

public abstract class SocketService
extends AbstractService {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$net$SocketService == null ? (class$openwfe$org$net$SocketService = SocketService.class$("openwfe.org.net.SocketService")) : class$openwfe$org$net$SocketService).getName());
    public static final String P_PORT = "port";
    public static final String P_INET_ADDRESS = "inetAddress";
    private int port = -1;
    private int defaultPort = 7000;
    static /* synthetic */ Class class$openwfe$org$net$SocketService;

    public void init(String string, ApplicationContext applicationContext, Map map) throws ServiceException {
        super.init(string, applicationContext, map);
        this.port = MapUtils.getAsInt(map, P_PORT, this.getDefaultPort());
        if (log.isDebugEnabled()) {
            log.debug((Object)("init() listening on port " + this.port));
        }
        InetAddress inetAddress = null;
        String string2 = MapUtils.getAsString(map, P_INET_ADDRESS);
        if (string2 != null) {
            try {
                inetAddress = InetAddress.getByName(string2);
            }
            catch (Exception exception) {
                log.info((Object)("Cannot resolve '" + string2 + "' to an inet address, listening on all interfaces"), (Throwable)exception);
            }
        }
        try {
            ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
            serverSocketChannel.socket().bind(new InetSocketAddress(inetAddress, this.port));
            serverSocketChannel.configureBlocking(false);
            final Selector selector = Selector.open();
            serverSocketChannel.register(selector, 16);
            new Thread(){

                public void run() {
                    while (SocketService.this.isRunning()) {
                        try {
                            int n = selector.select();
                            if (n == 0) continue;
                            Iterator<SelectionKey> iterator = selector.selectedKeys().iterator();
                            while (iterator.hasNext()) {
                                SelectionKey selectionKey = iterator.next();
                                if (selectionKey.isAcceptable()) {
                                    ServerSocketChannel serverSocketChannel = (ServerSocketChannel)selectionKey.channel();
                                    SocketChannel socketChannel = serverSocketChannel.accept();
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)("Incoming connection: " + SocketService.prettyPrintSocket(socketChannel.socket())));
                                    }
                                    SocketService.registerChannel(selector, socketChannel, 1);
                                    log.debug((Object)"channel registered.");
                                }
                                if (selectionKey.isReadable()) {
                                    SocketService.this.handle(selectionKey);
                                }
                                iterator.remove();
                            }
                        }
                        catch (Throwable throwable) {
                            log.info((Object)"Handling of a socket failed", throwable);
                        }
                    }
                }
            }.start();
        }
        catch (Throwable throwable) {
            log.warn((Object)"Socket handling failed. Service stopped.", throwable);
        }
    }

    private static String prettyPrintSocket(Socket socket) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("remote ");
        stringBuffer.append(socket.getInetAddress());
        stringBuffer.append(":");
        stringBuffer.append(socket.getPort());
        stringBuffer.append(" <--> local ");
        stringBuffer.append(socket.getLocalAddress());
        stringBuffer.append(":");
        stringBuffer.append(socket.getLocalPort());
        return stringBuffer.toString();
    }

    private static void registerChannel(Selector selector, SelectableChannel selectableChannel, int n) throws IOException {
        if (selectableChannel == null) {
            return;
        }
        selectableChannel.configureBlocking(false);
        selectableChannel.register(selector, n);
    }

    public int getPort() {
        return this.port;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public void setDefaultPort(int n) {
        this.defaultPort = n;
    }

    public abstract void handle(SelectionKey var1) throws ServiceException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

