/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.time;

import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import openwfe.org.time.CronLine;
import openwfe.org.time.Schedulable;
import openwfe.org.time.Time;
import org.apache.log4j.Logger;

public class Scheduler {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$time$Scheduler == null ? (class$openwfe$org$time$Scheduler = Scheduler.class$("openwfe.org.time.Scheduler")) : class$openwfe$org$time$Scheduler).getName());
    private String name = null;
    private long sleepTime = 250L;
    private SchedulerThread thread = null;
    private List pendingJobs = new LinkedList();
    private boolean daemonIfIdle = false;
    private HashMap cronEntries = null;
    private long lastGivenCronId = -1L;
    private long lastGivenAtId = -1L;
    private long lastCronMinute = -1L;
    static /* synthetic */ Class class$openwfe$org$time$Scheduler;

    public Scheduler() {
        this("scheduler");
    }

    public Scheduler(String string) {
        this.name = string;
        this.thread = new SchedulerThread(this.name);
        this.cronEntries = new LinkedHashMap();
    }

    public String getName() {
        return this.name;
    }

    public void setDaemon(boolean bl) {
        this.thread.setDaemon(bl);
    }

    public boolean isDaemon() {
        return this.thread.isDaemon();
    }

    public void setDaemonIfIdle(boolean bl) {
        this.daemonIfIdle = bl;
    }

    public boolean isDaemonIfIdle() {
        return this.daemonIfIdle;
    }

    public void setPrecision(float f) {
        this.sleepTime = (int)(f * 1000.0f);
    }

    public void stop() {
        this.thread.setRunning(false);
        this.thread = new SchedulerThread(this.name);
    }

    public void start() {
        this.thread.start();
    }

    public synchronized Long scheduleAt(long l, Schedulable schedulable, Object[] objectArray) {
        JobEntry jobEntry = new JobEntry(l, schedulable, objectArray);
        if (l <= System.currentTimeMillis() + this.sleepTime) {
            jobEntry.trigger();
            return null;
        }
        this.restartThread(false);
        if (this.pendingJobs.size() < 1) {
            this.pendingJobs.add(jobEntry);
        } else {
            JobEntry jobEntry2 = (JobEntry)this.pendingJobs.get(this.pendingJobs.size() - 1);
            if (l >= jobEntry2.getAt()) {
                this.pendingJobs.add(jobEntry);
            } else {
                for (int i = 0; i <= this.pendingJobs.size(); ++i) {
                    if (i == this.pendingJobs.size()) {
                        this.pendingJobs.add(jobEntry);
                        break;
                    }
                    JobEntry jobEntry3 = (JobEntry)this.pendingJobs.get(i);
                    if (l > jobEntry3.getAt()) continue;
                    this.pendingJobs.add(i, jobEntry);
                    break;
                }
            }
        }
        return new Long(jobEntry.id);
    }

    public Long scheduleAt(String string, Schedulable schedulable, Object[] objectArray) throws ParseException {
        return this.scheduleAt(Time.fromIsoDate(string), schedulable, objectArray);
    }

    public synchronized boolean unscheduleAt(Long l) {
        for (int i = 0; i < this.pendingJobs.size(); ++i) {
            JobEntry jobEntry = (JobEntry)this.pendingJobs.get(i);
            if (jobEntry.id != l) continue;
            this.pendingJobs.remove(i);
            return true;
        }
        return false;
    }

    public Long scheduleIn(long l, Schedulable schedulable, Object[] objectArray) {
        return this.scheduleAt(System.currentTimeMillis() + l, schedulable, objectArray);
    }

    public Long scheduleIn(String string, Schedulable schedulable, Object[] objectArray) {
        return this.scheduleIn(Time.parseTimeString(string), schedulable, objectArray);
    }

    public synchronized Long schedule(CronLine cronLine, Schedulable schedulable, Object[] objectArray) {
        ++this.lastGivenCronId;
        Long l = new Long(this.lastGivenCronId);
        this.cronEntries.put(l, new CronEntry(cronLine, schedulable, objectArray));
        return l;
    }

    public Long schedule(String string, Schedulable schedulable, Object[] objectArray) {
        return this.schedule(CronLine.parse(string), schedulable, objectArray);
    }

    public synchronized boolean unschedule(Long l) {
        Object v = this.cronEntries.remove(l);
        return v != null;
    }

    private synchronized void restartThread(boolean bl) {
        if (bl == this.thread.isDaemon()) {
            return;
        }
        this.thread.setRunning(false);
        this.thread = new SchedulerThread(this.name);
        this.thread.setDaemon(bl);
        this.thread.start();
    }

    protected synchronized void wakeup() {
        while (true) {
            Object object;
            long l;
            long l2;
            if ((l2 = (l = System.currentTimeMillis()) / 60000L) > this.lastCronMinute) {
                this.lastCronMinute = l2;
                object = this.cronEntries.keySet().iterator();
                while (object.hasNext()) {
                    CronEntry cronEntry = (CronEntry)this.cronEntries.get(object.next());
                    if (!cronEntry.matches(l)) continue;
                    cronEntry.trigger();
                }
            }
            if (this.pendingJobs.size() < 1) {
                if (!this.daemonIfIdle) break;
                this.restartThread(true);
                break;
            }
            object = (JobEntry)this.pendingJobs.get(0);
            if (((JobEntry)object).getAt() > l) break;
            if (((JobEntry)object).getAt() <= l) {
                ((Entry)object).trigger();
            }
            this.pendingJobs.remove(0);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Scheduler scheduler = new Scheduler();
        scheduler.setDaemon(false);
        scheduler.start();
        System.out.println("* Scheduler started at " + new Date());
        long l = System.currentTimeMillis() + 5000L;
        System.out.println("    + scheduling job at " + new Date(l));
        scheduler.scheduleAt(l, new Schedulable(){

            public void trigger(Object[] objectArray) {
                System.out.println(". (1) triggered at " + new Date());
            }

            public Long reschedule(Scheduler scheduler) {
                return new Long(-1L);
            }
        }, null);
        scheduler.schedule(CronLine.parse("4-6/2 * * * *"), new Schedulable(){

            public void trigger(Object[] objectArray) {
                System.out.println(". (c) triggered at " + new Date());
            }

            public Long reschedule(Scheduler scheduler) {
                return new Long(-1L);
            }
        }, null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SchedulerThread
    extends Thread {
        private boolean running = false;

        public SchedulerThread(String string) {
            this.setName(string);
        }

        public void run() {
            while (true) {
                try {
                    while (this.running) {
                        Scheduler.this.wakeup();
                        SchedulerThread.sleep(Scheduler.this.sleepTime);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (Throwable throwable) {
                    log.debug((Object)"run() schedule problem", throwable);
                    continue;
                }
                break;
            }
        }

        public void start() {
            if (this.running) {
                return;
            }
            this.running = true;
            super.start();
        }

        public void setRunning(boolean bl) {
            this.running = bl;
        }
    }

    private static class JobEntry
    extends Entry {
        private static long lastGivenAtId = -1L;
        protected long at = -1L;
        protected long id = -1L;

        public JobEntry(long l, Schedulable schedulable, Object[] objectArray) {
            super(schedulable, objectArray);
            this.at = l;
            this.id = JobEntry.newAtId();
        }

        public long getAt() {
            return this.at;
        }

        private static synchronized long newAtId() {
            return ++lastGivenAtId;
        }
    }

    private static class CronEntry
    extends Entry {
        protected CronLine cronLine = null;

        public CronEntry(CronLine cronLine, Schedulable schedulable, Object[] objectArray) {
            super(schedulable, objectArray);
            this.cronLine = cronLine;
        }

        public boolean matches(long l) {
            return this.cronLine.matches(l);
        }
    }

    private static class Entry {
        protected Schedulable target = null;
        protected Object[] params = null;

        public Entry(Schedulable schedulable, Object[] objectArray) {
            this.target = schedulable;
            this.params = objectArray;
        }

        public void trigger() {
            try {
                this.target.trigger(this.params);
            }
            catch (Throwable throwable) {
                log.error((Object)"trigger() exception occurred within scheduled job", throwable);
            }
        }
    }
}

