/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.xml;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import openwfe.org.ReflectionUtils;
import openwfe.org.xml.XmlCodingException;
import openwfe.org.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;

public abstract class XmlCoder {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$xml$XmlCoder == null ? (class$openwfe$org$xml$XmlCoder = XmlCoder.class$("openwfe.org.xml.XmlCoder")) : class$openwfe$org$xml$XmlCoder).getName());
    private static final String E_INSTANCE = "instance";
    private static final String E_FIELD = "field";
    private static final String E_ARRAY = "array";
    private static final String E_PRIMITIVE = "primitive";
    private static final String E_MAP = "map";
    private static final String E_COLLECTION = "collection";
    private static final String E_NULL = "null";
    private static final String E_JDOM = "jdom";
    private static final String E_ENTRY = "entry";
    private static final String A_CLASS = "class";
    private static final String A_SIZE = "size";
    private static final String A_NAME = "name";
    private static final String IS = "is";
    private static final String SET = "set";
    static /* synthetic */ Class class$openwfe$org$xml$XmlCoder;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$Collection;

    private static boolean isPrimitive(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = XmlCoder.class$("java.lang.String")) : class$java$lang$String)) {
            return true;
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = XmlCoder.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return true;
        }
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = XmlCoder.class$("java.lang.Long")) : class$java$lang$Long)) {
            return true;
        }
        if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = XmlCoder.class$("java.lang.Short")) : class$java$lang$Short)) {
            return true;
        }
        if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = XmlCoder.class$("java.lang.Float")) : class$java$lang$Float)) {
            return true;
        }
        if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = XmlCoder.class$("java.lang.Double")) : class$java$lang$Double)) {
            return true;
        }
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = XmlCoder.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return true;
        }
        if (clazz == (class$java$lang$Character == null ? (class$java$lang$Character = XmlCoder.class$("java.lang.Character")) : class$java$lang$Character)) {
            return true;
        }
        return clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = XmlCoder.class$("java.lang.Byte")) : class$java$lang$Byte);
    }

    private static void encodeField(Object object, Element element, Method method) throws Exception {
        Element element2 = new Element(E_FIELD);
        String string = method.getName();
        String string2 = string.substring(3);
        if (string.startsWith(IS)) {
            string2 = string.substring(2);
        }
        element2.setAttribute(A_NAME, string2);
        Object[] objectArray = null;
        Object object2 = method.invoke(object, objectArray);
        element2.addContent((Content)XmlCoder.encode(object2));
        element.addContent((Content)element2);
    }

    private static Element encodePrimitive(Object object) {
        Element element = new Element(E_PRIMITIVE);
        element.setAttribute(A_CLASS, object.getClass().getName());
        element.addContent((Content)new Text(object.toString()));
        return element;
    }

    private static Element encodeArray(Object object) throws Exception {
        Element element = new Element(E_ARRAY);
        Object var2_2 = null;
        boolean bl = true;
        for (int i = 0; i < Array.getLength(object); ++i) {
            Object object2 = Array.get(object, i);
            element.addContent((Content)XmlCoder.encode(object2));
        }
        element.setAttribute(A_SIZE, "" + Array.getLength(object));
        return element;
    }

    private static Element encodeMap(Object object) throws Exception {
        Map map = (Map)object;
        Element element = new Element(E_MAP);
        element.setAttribute(A_CLASS, object.getClass().getName());
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object v = map.get(k);
            Element element2 = new Element(E_ENTRY);
            element2.addContent((Content)XmlCoder.encode(k));
            element2.addContent((Content)XmlCoder.encode(v));
            element.addContent((Content)element2);
        }
        return element;
    }

    private static Element encodeCollection(Object object) throws Exception {
        Element element = new Element(E_COLLECTION);
        element.setAttribute(A_CLASS, object.getClass().getName());
        Iterator iterator = ((Collection)object).iterator();
        while (iterator.hasNext()) {
            element.addContent((Content)XmlCoder.encode(iterator.next()));
        }
        return element;
    }

    private static Element encodeJdomElement(Object object) {
        Element element = new Element(E_JDOM);
        Element element2 = (Element)object;
        element2.detach();
        element.addContent((Content)element2);
        return element;
    }

    public static String encodeToString(Object object, String string) throws XmlCodingException {
        Document document = new Document(XmlCoder.encode(object));
        return XmlUtils.toString(document, string);
    }

    public static String encodeToString(Object object) throws XmlCodingException {
        return XmlCoder.encodeToString(object, null);
    }

    public static String dumpToString(Object object) {
        try {
            return XmlCoder.encodeToString(object, null);
        }
        catch (Throwable throwable) {
            return ">failed to dumpToString : " + throwable + "<";
        }
    }

    public static Element encode(Object object) throws XmlCodingException {
        if (object == null) {
            return new Element(E_NULL);
        }
        try {
            if (object.getClass().isArray()) {
                return XmlCoder.encodeArray(object);
            }
            if ((class$java$util$Map == null ? (class$java$util$Map = XmlCoder.class$("java.util.Map")) : class$java$util$Map).isInstance(object)) {
                return XmlCoder.encodeMap(object);
            }
            if ((class$java$util$Collection == null ? (class$java$util$Collection = XmlCoder.class$("java.util.Collection")) : class$java$util$Collection).isInstance(object)) {
                return XmlCoder.encodeCollection(object);
            }
            if (XmlCoder.isPrimitive(object)) {
                return XmlCoder.encodePrimitive(object);
            }
            if (object instanceof Element) {
                return XmlCoder.encodeJdomElement(object);
            }
        }
        catch (Exception exception) {
            throw new XmlCodingException("Encoding failure for bean of class '" + object.getClass().getName() + "'", exception);
        }
        Element element = new Element(E_INSTANCE);
        element.setAttribute(A_CLASS, object.getClass().getName());
        Iterator iterator = ReflectionUtils.listReadWriteFields(object).iterator();
        while (iterator.hasNext()) {
            Method[] methodArray = (Method[])iterator.next();
            try {
                XmlCoder.encodeField(object, element, methodArray[0]);
            }
            catch (Exception exception) {
                throw new XmlCodingException("Failed to encode field behind getter '" + methodArray[0].getName() + "' for bean of class '" + object.getClass().getName() + "'", exception);
            }
        }
        return element;
    }

    private static Class getClass(Element element) throws ClassNotFoundException {
        String string = element.getAttributeValue(A_CLASS);
        return Class.forName(string);
    }

    private static int getSize(Element element) {
        String string = element.getAttributeValue(A_SIZE);
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return 10;
        }
    }

    private static Object decodeArray(Element element) throws Exception {
        Object[] objectArray = new Object[XmlCoder.getSize(element)];
        int n = 0;
        Iterator iterator = element.getChildren().iterator();
        while (iterator.hasNext()) {
            objectArray[n] = XmlCoder.decode((Element)iterator.next());
            ++n;
        }
        return objectArray;
    }

    private static Object decodeMap(Element element) throws Exception {
        Map map = (Map)XmlCoder.getClass(element).newInstance();
        Iterator iterator = element.getChildren().iterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            Object object = XmlCoder.decode((Element)element2.getChildren().get(0));
            Object object2 = XmlCoder.decode((Element)element2.getChildren().get(1));
            map.put(object, object2);
        }
        return map;
    }

    private static Object decodeCollection(Element element) throws Exception {
        Collection collection = (Collection)XmlCoder.getClass(element).newInstance();
        Iterator iterator = element.getChildren().iterator();
        while (iterator.hasNext()) {
            collection.add(XmlCoder.decode((Element)iterator.next()));
        }
        return collection;
    }

    private static Object invokeStringConstructor(Class clazz, String string) throws Exception {
        Constructor constructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = XmlCoder.class$("java.lang.String")) : class$java$lang$String);
        return constructor.newInstance(string);
    }

    private static Object decodePrimitive(Element element) throws Exception {
        Class clazz = XmlCoder.getClass(element);
        if (clazz == (class$java$lang$Character == null ? (class$java$lang$Character = XmlCoder.class$("java.lang.Character")) : class$java$lang$Character)) {
            return new Character(element.getText().charAt(0));
        }
        return XmlCoder.invokeStringConstructor(clazz, element.getText());
    }

    private static Object decodeJdomElement(Element element) throws Exception {
        return element.getChildren().get(0);
    }

    public static Object decode(Document document) throws XmlCodingException {
        return XmlCoder.decode(document.getRootElement());
    }

    public static Object decode(Element element) throws XmlCodingException {
        if (element.getName().equals(E_NULL)) {
            return null;
        }
        try {
            Object object;
            Object object2;
            Object object3;
            Method[] methodArray;
            if (element.getName().equals(E_ARRAY)) {
                return XmlCoder.decodeArray(element);
            }
            if (element.getName().equals(E_MAP)) {
                return XmlCoder.decodeMap(element);
            }
            if (element.getName().equals(E_COLLECTION)) {
                return XmlCoder.decodeCollection(element);
            }
            if (element.getName().equals(E_PRIMITIVE)) {
                return XmlCoder.decodePrimitive(element);
            }
            if (element.getName().equals(E_JDOM)) {
                return XmlCoder.decodeJdomElement(element);
            }
            Class clazz = XmlCoder.getClass(element);
            Object t = clazz.newInstance();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            Iterator iterator = element.getChildren(E_FIELD).iterator();
            while (iterator.hasNext()) {
                methodArray = (Method[])iterator.next();
                object3 = methodArray.getAttributeValue(A_NAME);
                object2 = (Element)methodArray.getChildren().get(0);
                object = XmlCoder.decode(object2);
                hashMap.put(SET + (String)object3, object);
            }
            iterator = ReflectionUtils.listReadWriteFields(clazz).iterator();
            while (iterator.hasNext()) {
                methodArray = (Method[])iterator.next();
                object3 = methodArray[1];
                object2 = ((Method)object3).getName();
                object = hashMap.get(object2);
                try {
                    ((Method)object3).invoke(t, object);
                }
                catch (Throwable throwable) {
                    log.warn((Object)("decode() failed to invoke '" + (String)object2 + "' on bean of class '" + clazz.getName() + "'. Continuing anyway..."), throwable);
                }
            }
            return t;
        }
        catch (Throwable throwable) {
            throw new XmlCodingException("Failed to decode elt named '" + element.getName() + "'", throwable);
        }
    }

    public static Object load(String string) throws IOException, JDOMException, XmlCodingException {
        return XmlCoder.decode(XmlUtils.extractXml(string, false));
    }

    public static Object load(URL uRL) throws IOException, JDOMException, XmlCodingException {
        return XmlCoder.decode(XmlUtils.extractXml(uRL, false));
    }

    public static void save(String string, Object object) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            XmlCoder.save(fileOutputStream, object);
        }
        catch (Throwable throwable) {
            log.error((Object)("save() failed to open outputstream to file " + string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(OutputStream outputStream, Object object) throws IOException, XmlCodingException {
        try {
            Document document = new Document(XmlCoder.encode(object));
            XmlUtils.getXMLOutputter().output(document, outputStream);
            outputStream.flush();
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Throwable throwable) {
                log.error((Object)"save() failed to encode as xml to given outputstream");
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

