/*
 * Decompiled with CFR 0.152.
 */
package openwfe.org.xml;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import openwfe.org.OpenWfeException;
import openwfe.org.Service;
import openwfe.org.Utils;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public abstract class XmlUtils {
    private static final Logger log = Logger.getLogger((String)(class$openwfe$org$xml$XmlUtils == null ? (class$openwfe$org$xml$XmlUtils = XmlUtils.class$("openwfe.org.xml.XmlUtils")) : class$openwfe$org$xml$XmlUtils).getName());
    static /* synthetic */ Class class$openwfe$org$xml$XmlUtils;

    public static Element extractXml(String string, boolean bl) throws JDOMException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("extractXml(sUrl) docUrl is >" + string + "<"));
        }
        if (string.startsWith("resource:")) {
            InputStream inputStream = (class$openwfe$org$xml$XmlUtils == null ? (class$openwfe$org$xml$XmlUtils = XmlUtils.class$("openwfe.org.xml.XmlUtils")) : class$openwfe$org$xml$XmlUtils).getResourceAsStream(string.substring(9));
            return XmlUtils.extractXml(inputStream, bl);
        }
        string = Utils.ensureProtocol(string);
        if (log.isDebugEnabled()) {
            log.debug((Object)("extractXml(sUrl) docUrl is >" + string + "<"));
        }
        return XmlUtils.extractXml(new URL(string), bl);
    }

    public static Element extractXml(InputStream inputStream, boolean bl) throws JDOMException, IOException {
        log.debug((Object)"extractXml(is)");
        SAXBuilder sAXBuilder = XmlUtils.getSAXBuilder(bl);
        Document document = sAXBuilder.build(inputStream);
        return document.getRootElement();
    }

    public static Element extractXml(File file, boolean bl) throws JDOMException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("extractXml(file) " + file.getName()));
        }
        SAXBuilder sAXBuilder = XmlUtils.getSAXBuilder(bl);
        Document document = sAXBuilder.build((InputStream)new FileInputStream(file));
        return document.getRootElement();
    }

    public static Element extractXml(URL uRL, boolean bl) throws JDOMException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("extractXml(url) " + uRL.toString()));
        }
        SAXBuilder sAXBuilder = XmlUtils.getSAXBuilder(bl);
        Document document = sAXBuilder.build(uRL);
        return document.getRootElement();
    }

    public static Element extractXml(URLConnection uRLConnection, boolean bl) throws JDOMException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("extractXml(uc) " + uRLConnection.getURL().toString()));
        }
        SAXBuilder sAXBuilder = XmlUtils.getSAXBuilder(bl);
        Document document = sAXBuilder.build(uRLConnection.getInputStream());
        return document.getRootElement();
    }

    public static Document extractXmlDocument(String string, boolean bl) throws JDOMException, IOException {
        if (string == null) {
            return null;
        }
        SAXBuilder sAXBuilder = XmlUtils.getSAXBuilder(bl);
        StringReader stringReader = new StringReader(string);
        return sAXBuilder.build((Reader)stringReader);
    }

    public static Element extractXmlElement(String string) throws JDOMException, IOException {
        Document document = XmlUtils.extractXmlDocument(string, false);
        if (document == null) {
            return null;
        }
        Element element = document.getRootElement();
        element.detach();
        return element;
    }

    public static Map fetchAttributes(Element element) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = element.getAttributes().iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            hashMap.put(attribute.getName(), attribute.getValue());
        }
        return hashMap;
    }

    public static byte[] toByteArray(Element element) throws OpenWfeException {
        byte[] byArray = XmlUtils.toByteArray(new Document(element));
        element.detach();
        return byArray;
    }

    public static byte[] toByteArray(Document document) throws OpenWfeException {
        XMLOutputter xMLOutputter = XmlUtils.getXMLOutputter();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            xMLOutputter.output(document, (OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.write(10);
            byteArrayOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new OpenWfeException("Failed to encode workitem as xml", iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static XMLOutputter getXMLOutputter(String string) {
        Format format = Format.getPrettyFormat();
        if (string == null) {
            string = Utils.getEncoding();
        }
        format.setEncoding(string);
        return new XMLOutputter(format);
    }

    public static XMLOutputter getXMLOutputter() {
        return XmlUtils.getXMLOutputter(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(String string, Element element) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            element.detach();
            Document document = new Document(element);
            fileOutputStream = new FileOutputStream(string);
            XmlUtils.getXMLOutputter().output(document, (OutputStream)fileOutputStream);
            fileOutputStream.flush();
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static String toString(Document document) {
        return XmlUtils.toString(document, null);
    }

    public static String toString(Document document, String string) {
        if (string == null) {
            string = Utils.getEncoding();
        }
        XMLOutputter xMLOutputter = XmlUtils.getXMLOutputter(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            xMLOutputter.output(document, (OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.write(10);
            byteArrayOutputStream.flush();
            return byteArrayOutputStream.toString(string);
        }
        catch (IOException iOException) {
            log.warn((Object)"Failed to encode workitem as xml", (Throwable)iOException);
            return "";
        }
    }

    public static String toString(Content content) {
        boolean bl;
        if (content instanceof Text) {
            return ((Text)content).getTextTrim();
        }
        Element element = (Element)content;
        boolean bl2 = bl = element.getParent() != null;
        if (bl) {
            element = (Element)element.clone();
        }
        String string = XmlUtils.toString(new Document(element), null);
        if (!bl) {
            element.detach();
        }
        return string;
    }

    public static Element getClassElt(Service service) {
        Element element = new Element("class");
        if (service == null) {
            element.addContent("null");
        } else {
            element.addContent(service.getClass().getName());
        }
        return element;
    }

    public static Element getRevisionElt(String string) {
        Element element = new Element("revision");
        if (string == null) {
            element.addContent("null");
        } else {
            element.addContent(string);
        }
        return element;
    }

    public static void setAttributes(Element element, Map map) {
        if (element == null) {
            return;
        }
        if (map == null) {
            return;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            String string2 = map.get(string).toString();
            element.setAttribute(string, string2);
        }
    }

    public static String dumpContent(Element element) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  --" + element.getName() + "--\n");
        Iterator iterator = element.getAttributes().iterator();
        while (iterator.hasNext()) {
            object = (Attribute)iterator.next();
            stringBuffer.append("     - " + object.getName() + "='" + object.getValue() + "'\n");
        }
        iterator = element.getContent().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (object instanceof Element) {
                Element element2 = (Element)object;
                stringBuffer.append("   * --" + element2.getName() + "--\n");
                continue;
            }
            stringBuffer.append("   * " + object.getClass().getName() + "\n");
        }
        return stringBuffer.toString();
    }

    public static SAXBuilder getSAXBuilder(boolean bl) {
        if (!bl) {
            return new SAXBuilder(false);
        }
        SAXBuilder sAXBuilder = new SAXBuilder("org.apache.xerces.parsers.SAXParser", true);
        sAXBuilder.setFeature("http://apache.org/xml/features/validation/schema", true);
        return sAXBuilder;
    }

    public static Element getFirstChild(Element element) {
        return XmlUtils.getChild(element, 0);
    }

    public static Element getChild(Element element, int n) {
        if (element == null) {
            return null;
        }
        int n2 = 0;
        Iterator iterator = element.getContent().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Element)) continue;
            if (n2 == n) {
                return (Element)e;
            }
            ++n2;
        }
        return null;
    }

    public static String fetchTextContent(Element element) {
        if (element.getContent().size() < 1) {
            return "";
        }
        Iterator iterator = element.getContent().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Text) {
                return ((Text)e).getTextTrim();
            }
            if (!(e instanceof CDATA)) continue;
            return ((CDATA)e).getTextTrim();
        }
        return null;
    }

    public static String fetchCdataContent(Element element) {
        if (element.getContent().size() < 1) {
            return "";
        }
        Iterator iterator = element.getContent().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof CDATA)) continue;
            return ((CDATA)e).getTextTrim();
        }
        return null;
    }

    public static String dump(String string, Element element) {
        try {
            return Utils.dump(string, XmlUtils.toByteArray(element));
        }
        catch (Throwable throwable) {
            log.debug((Object)"dump() failure", throwable);
            return null;
        }
    }

    public static String dump(String string, Document document) {
        try {
            return Utils.dump(string, XmlUtils.toByteArray(document));
        }
        catch (Throwable throwable) {
            log.debug((Object)"dump() failure", throwable);
            return null;
        }
    }

    public static String removeHeaderLine(String string) {
        if (!string.startsWith("<?xml")) {
            return string;
        }
        int n = string.indexOf(">");
        String string2 = string.substring(n + 1);
        return string2.trim();
    }

    public static String xmlToString(Content content) {
        return XmlUtils.removeHeaderLine(XmlUtils.toString(content));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

