/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: AbstractUnicastService.java 2713 2006-06-01 14:38:45Z jmettraux $
 */

//
// AbstractUnicastService.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.rmi;

import openwfe.org.Service;
import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;


/**
 * A simple Service to use as a remote class for RemoteService.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: AbstractUnicastService.java 2713 2006-06-01 14:38:45Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public class AbstractUnicastService

    extends java.rmi.server.UnicastRemoteObject

    implements Service

{

    /*
    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(AbstractUnicastService.class.getName());
    */

    //
    // CONSTANTS & co

    //
    // FIELDS

    private String serviceName = null;
    private ApplicationContext applicationContext = null;
    private java.util.Map serviceParams = null;

    //
    // CONSTRUCTORS

    /**
     * The non parameter constructor (that must throw java.rmi.RemoteException).
     */
    public AbstractUnicastService ()
        throws java.rmi.RemoteException
    {
        super();
    }

    /**
     * This is a Service, so it has this init() method.
     */
    public void init
        (final String serviceName,
         final ApplicationContext ac,
         final java.util.Map serviceParams)
    throws
        ServiceException
    {
        this.serviceName = serviceName;
        this.applicationContext = ac;
        this.serviceParams = serviceParams;
    }

    //
    // METHODS from Service

    /**
     * Returns the name of this Service.
     */
    public String getName ()
    {
        return this.serviceName;
    }

    /**
     * A dumb implementation, will return the name of this service as
     * an element.
     */
    public org.jdom.Element getStatus ()
    {
        final org.jdom.Element result = new org.jdom.Element(this.serviceName);
        result.setAttribute("class", this.getClass().getName());

        return result;
    }

    /**
     * Returns the param map used to initialize this Service (and Remote).
     */
    public java.util.Map getParams ()
    {
        return this.serviceParams;
    }

    /**
     * Returns the application in which this Service lives.
     */
    public ApplicationContext getContext ()
    {
        return this.applicationContext;
    }

    //
    // METHODS

    //
    // STATIC METHODS

}
