/*
 * Copyright (c) 2001-2006, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: ClassedWorkSessionServer.java 2713 2006-06-01 14:38:45Z jmettraux $
 */

//
// ClassedWorkSessionServer.java
//
// jmettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.00 16.08.2003 John Mettraux (jmettraux@openwfe.org)
//

package openwfe.org.rmi.session;

import openwfe.org.Utils;
import openwfe.org.MapUtils;
import openwfe.org.Service;
import openwfe.org.RunnableService;
import openwfe.org.ServiceException;
import openwfe.org.ApplicationContext;
import openwfe.org.state.ServiceState;
import openwfe.org.state.ServiceStateHelper;


/**
 * Half an implementation of a WorkSessionServer 
 * (just registering the RemoteSession class).
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: jmettraux $
 * <br>$Id: ClassedWorkSessionServer.java 2713 2006-06-01 14:38:45Z jmettraux $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public abstract class ClassedWorkSessionServer

    extends RunnableWorkSessionServer

{

    private final static org.apache.log4j.Logger log = org.apache.log4j.Logger
        .getLogger(ClassedWorkSessionServer.class.getName());

    //
    // CONSTANTS & co

    public final static String P_REMOTE_SESSION_IMPL_CLASS
        = "remoteSessionImplClass";

    /**
     * This server stores the Subject instance in the params of its 
     * new born sessions under this '__subject__' key.
     */
    public final static String P_SUBJECT
        = "__subject__";

    //
    // FIELDS

    private Class sessionImplClass = null;

    //
    // CONSTRUCTORS

    public ClassedWorkSessionServer ()
        throws java.rmi.RemoteException
    {
        super();
    }

    public void init 
        (final String serviceName, 
         final ApplicationContext context, 
         final java.util.Map serviceParams)
    throws 
        ServiceException
    {
        super.init(serviceName, context, serviceParams);

        //
        // fetch remote session impl class
        
        final String remoteSessionImplClassName = MapUtils.getMandatoryString
            (serviceParams,
             P_REMOTE_SESSION_IMPL_CLASS);

        try
        {
            this.sessionImplClass = Class.forName(remoteSessionImplClassName);
        }
        catch (final Throwable t)
        {
            //throw new java.rmi.RemoteException
            throw new ServiceException
                ("Failed to load sessionImplClass '"+
                 remoteSessionImplClassName+"'", t);
        }

        log.info
            ("init() RemoteSessionImplClass set to '"+
             remoteSessionImplClassName+"'");
    }

    //
    // METHODS from Service

    //
    // METHODS

    /**
     * Returns the class that this server, well, serves...
     */
    protected Class getSessionImplClass ()
    {
        return this.sessionImplClass;
    }

    /**
     * Instantiates a RemoteSession and returns it.
     *
     * @param subject generally a Subject instance, could be a string containing
     * the username.
     */
    protected java.rmi.Remote newRemoteSession (final Object subject)
        throws ServiceException, java.rmi.RemoteException
    {
        java.rmi.Remote session = null;
        try
        {
            session = (java.rmi.Remote)getSessionImplClass().newInstance();
        }
        catch (final Throwable t)
        {
            throw new java.rmi.RemoteException
                ("Failed to instantiate session of class '"+
                 getSessionImplClass().getName()+"'", t);
        }
        //session.init(getContext(), getParams(), subject);

        if (session instanceof Service)
        {
            final String sessionName =
                this.getName() + "_session_" + session.toString();

            final java.util.Map sessionParams = 
                Utils.copyHashMap(this.getParams());

            sessionParams.put(P_SUBJECT, subject);

            ((Service)session).init
                (sessionName,
                 this.getContext(),
                 sessionParams);
        }
        else
        {
            log.info
                ("newRemoteSession() "+
                 "session of class '"+this.sessionImplClass.getName()+
                 "' doesn't extend '"+Service.class.getName()+"'");
        }

        if (log.isDebugEnabled())
            log.debug("newRemoteSession() spawned a session for '"+subject+"'");

        return session;
    }

}
